/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.Math;
import smile.math.distance.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MahalanobisDistance
implements Metric<double[]> {
    private double[][] sigma;
    private double[][] sigmaInv;

    public MahalanobisDistance(double[][] cov) {
        this.sigma = new double[cov.length][cov.length];
        for (int i = 0; i < cov.length; ++i) {
            System.arraycopy(cov[i], 0, this.sigma[i], 0, cov.length);
        }
        this.sigmaInv = Math.inverse(this.sigma);
    }

    public String toString() {
        return "Mahalanobis distance";
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != this.sigma.length) {
            throw new IllegalArgumentException(String.format("Array x[%d] has different dimension with Sigma[%d][%d].", x.length, this.sigma.length, this.sigma.length));
        }
        if (y.length != this.sigma.length) {
            throw new IllegalArgumentException(String.format("Array y[%d] has different dimension with Sigma[%d][%d].", y.length, this.sigma.length, this.sigma.length));
        }
        int n = x.length;
        double[] z = new double[n];
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] - y[i];
        }
        double dist = Math.xax(this.sigmaInv, z);
        return Math.sqrt(dist);
    }
}

