/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.Iterator;
import smile.math.SparseArray;
import smile.math.distance.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseEuclideanDistance
implements Metric<SparseArray> {
    private double[] weight = null;

    public SparseEuclideanDistance() {
    }

    public SparseEuclideanDistance(double[] weight) {
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight has to be nonnegative: %f", weight[i]));
        }
        this.weight = weight;
    }

    public String toString() {
        if (this.weight != null) {
            return "weighted Euclidean distance";
        }
        return "Euclidean distance";
    }

    @Override
    public double d(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double dist = 0.0;
        if (this.weight == null) {
            double d;
            while (a != null && b != null) {
                if (a.i < b.i) {
                    d = a.x;
                    dist += d * d;
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    d = b.x;
                    dist += d * d;
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.x - b.x;
                dist += d * d;
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.x;
                dist += d * d;
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.x;
                dist += d * d;
                b = iterY.hasNext() ? iterY.next() : null;
            }
        } else {
            double d;
            while (a != null && b != null) {
                if (a.i < b.i) {
                    d = a.x;
                    dist += this.weight[a.i] * d * d;
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    d = b.x;
                    dist += this.weight[b.i] * d * d;
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.x - b.x;
                dist += this.weight[a.i] * d * d;
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.x;
                dist += this.weight[a.i] * d * d;
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.x;
                dist += this.weight[b.i] * d * d;
                b = iterY.hasNext() ? iterY.next() : null;
            }
        }
        return Math.sqrt(dist);
    }
}

