/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaplacianKernel
implements MercerKernel<double[]> {
    private double gamma;

    public LaplacianKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 1.0 / sigma;
    }

    public String toString() {
        return String.format("Laplacian Kernel (\u02e0 = %.4f)", 1.0 / this.gamma);
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        return Math.exp(-this.gamma * Math.distance(x, y));
    }
}

