/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.IMatrix;

public class SingularValueDecomposition {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private boolean full;
    private int m;
    private int n;
    private double tol;

    private SingularValueDecomposition(double[][] U, double[][] V, double[] s) {
        this(U, V, s, true);
    }

    private SingularValueDecomposition(double[][] U, double[][] V, double[] s, boolean full) {
        this.U = U;
        this.V = V;
        this.s = s;
        this.full = full;
        this.m = U.length;
        this.n = V.length;
        this.tol = 0.5 * Math.sqrt((double)(U.length + V.length) + 1.0) * s[0] * Math.EPSILON;
    }

    public double[][] getU() {
        return this.U;
    }

    public double[][] getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public double[][] getS() {
        double[][] S = new double[this.V.length][this.V.length];
        for (int i = 0; i < this.s.length; ++i) {
            S[i][i] = this.s[i];
        }
        return S;
    }

    public double norm() {
        return this.s[0];
    }

    public int rank() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > this.tol)) continue;
            ++r;
        }
        return r;
    }

    public int nullity() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] <= this.tol)) continue;
            ++r;
        }
        return r;
    }

    public double condition() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        return this.s[0] <= 0.0 || this.s[this.n - 1] <= 0.0 ? Double.POSITIVE_INFINITY : this.s[0] / this.s[this.n - 1];
    }

    public double[][] range() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nr = 0;
        double[][] rnge = new double[this.m][this.rank()];
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] > this.tol)) continue;
            for (int i = 0; i < this.m; ++i) {
                rnge[i][nr] = this.U[i][j];
            }
            ++nr;
        }
        return rnge;
    }

    public double[][] nullspace() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nn = 0;
        double[][] nullsp = new double[this.n][this.nullity()];
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] <= this.tol)) continue;
            for (int jj = 0; jj < this.n; ++jj) {
                nullsp[jj][nn] = this.V[jj][j];
            }
            ++nn;
        }
        return nullsp;
    }

    public void solve(double[] b, double[] x) {
        double r;
        int j;
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (b.length != this.m || x.length != this.n) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] tmp = new double[this.n];
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            if (this.s[j] > this.tol) {
                for (int i = 0; i < this.m; ++i) {
                    r += this.U[i][j] * b[i];
                }
                r /= this.s[j];
            }
            tmp[j] = r;
        }
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            for (int jj = 0; jj < this.n; ++jj) {
                r += this.V[j][jj] * tmp[jj];
            }
            x[j] = r;
        }
    }

    public void solve(double[][] B, double[][] X) {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (B.length != this.n || X.length != this.n || B[0].length != X[0].length) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] xx = new double[this.n];
        int p = B[0].length;
        for (int j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < this.n; ++i) {
                xx[i] = B[i][j];
            }
            this.solve(xx, xx);
            for (i = 0; i < this.n; ++i) {
                X[i][j] = xx[i];
            }
        }
    }

    public static SingularValueDecomposition decompose(IMatrix A, int k) {
        return SingularValueDecomposition.decompose(A, k, 1.0E-6);
    }

    public static SingularValueDecomposition decompose(IMatrix A, int k, double kappa) {
        ATA B = new ATA(A);
        EigenValueDecomposition eigen = EigenValueDecomposition.decompose(B, k, kappa);
        double[] s = eigen.getEigenValues();
        for (int i = 0; i < s.length; ++i) {
            s[i] = Math.sqrt(s[i]);
        }
        if (A.nrows() >= A.ncols()) {
            double[][] V = eigen.getEigenVectors();
            double[] tmp = new double[A.nrows()];
            double[] vi = new double[A.ncols()];
            double[][] U = new double[A.nrows()][s.length];
            for (int i = 0; i < s.length; ++i) {
                int j;
                for (j = 0; j < A.ncols(); ++j) {
                    vi[j] = V[j][i];
                }
                A.ax(vi, tmp);
                for (j = 0; j < A.nrows(); ++j) {
                    U[j][i] = tmp[j] / s[i];
                }
            }
            return new SingularValueDecomposition(U, V, s, false);
        }
        double[][] U = eigen.getEigenVectors();
        double[] tmp = new double[A.ncols()];
        double[] ui = new double[A.nrows()];
        double[][] V = new double[A.ncols()][s.length];
        for (int i = 0; i < s.length; ++i) {
            int j;
            for (j = 0; j < A.nrows(); ++j) {
                ui[j] = U[j][i];
            }
            A.atx(ui, tmp);
            for (j = 0; j < A.ncols(); ++j) {
                V[j][i] = tmp[j] / s[i];
            }
        }
        return new SingularValueDecomposition(U, V, s, false);
    }

    public static SingularValueDecomposition decompose(double[][] A) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int m = A.length;
        int n = A[0].length;
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        double[][] u = A;
        double[][] v = new double[n][n];
        double[] w = new double[n];
        double[] rv1 = new double[n];
        for (i = 0; i < n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                for (k = i; k < m; ++k) {
                    scale += Math.abs(u[k][i]);
                }
                if (scale != 0.0) {
                    for (k = i; k < m; ++k) {
                        double[] dArray = u[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += u[k][i] * u[k][i];
                    }
                    f = u[i][i];
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    u[i][i] = f - g;
                    for (j = l - 1; j < n; ++j) {
                        s = 0.0;
                        for (k = i; k < m; ++k) {
                            s += u[k][i] * u[k][j];
                        }
                        f = s / h;
                        for (k = i; k < m; ++k) {
                            double[] dArray = u[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * u[k][i];
                        }
                    }
                    for (k = i; k < m; ++k) {
                        double[] dArray = u[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= m && i + 1 != n) {
                for (k = l - 1; k < n; ++k) {
                    scale += Math.abs(u[i][k]);
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < n; ++k) {
                        double[] dArray = u[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += u[i][k] * u[i][k];
                    }
                    f = u[i][l - 1];
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    u[i][l - 1] = f - g;
                    for (k = l - 1; k < n; ++k) {
                        rv1[k] = u[i][k] / h;
                    }
                    for (j = l - 1; j < m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < n; ++k) {
                            s += u[j][k] * u[i][k];
                        }
                        for (k = l - 1; k < n; ++k) {
                            double[] dArray = u[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                        }
                    }
                    k = l - 1;
                    while (k < n) {
                        double[] dArray = u[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        v[j][i] = u[i][j] / u[i][l] / g;
                    }
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += u[i][k] * v[k][j];
                        }
                        for (k = l; k < n; ++k) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = Math.min(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            for (j = l; j < n; ++j) {
                u[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (k = l; k < m; ++k) {
                        s += u[k][i] * u[k][j];
                    }
                    f = s / u[i][i] * g;
                    for (k = i; k < m; ++k) {
                        double[] dArray = u[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * u[k][i];
                    }
                }
                for (j = i; j < m; ++j) {
                    double[] dArray = u[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                }
            } else {
                for (j = i; j < m; ++j) {
                    u[j][i] = 0.0;
                }
            }
            double[] dArray = u[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        block27: for (k = n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (l == 0 || Math.abs(rv1[l]) <= Math.EPSILON * anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) <= Math.EPSILON * anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) <= Math.EPSILON * anorm) break;
                        g = w[i];
                        w[i] = h = Math.hypot(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; ++j) {
                            y = u[j][nm];
                            z = u[j][i];
                            u[j][nm] = y * c + z * s;
                            u[j][i] = z * c - y * s;
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 0; j < n; ++j) {
                        v[j][k] = -v[j][k];
                    }
                    continue block27;
                }
                if (its == 29) {
                    throw new IllegalStateException("no convergence in 30 iterations");
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = Math.hypot(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + Math.copySign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = Math.hypot(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                    }
                    w[j] = z = Math.hypot(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; ++jj) {
                        y = u[jj][j];
                        z = u[jj][i];
                        u[jj][j] = y * c + z * s;
                        u[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
        int inc = 1;
        double[] su = new double[m];
        double[] sv = new double[n];
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (i = inc /= 3; i < n; ++i) {
                double sw = w[i];
                for (k = 0; k < m; ++k) {
                    su[k] = u[k][i];
                }
                for (k = 0; k < n; ++k) {
                    sv[k] = v[k][i];
                }
                j = i;
                while (w[j - inc] < sw) {
                    w[j] = w[j - inc];
                    for (k = 0; k < m; ++k) {
                        u[k][j] = u[k][j - inc];
                    }
                    for (k = 0; k < n; ++k) {
                        v[k][j] = v[k][j - inc];
                    }
                    if ((j -= inc) >= inc) continue;
                }
                w[j] = sw;
                for (k = 0; k < m; ++k) {
                    u[k][j] = su[k];
                }
                for (k = 0; k < n; ++k) {
                    v[k][j] = sv[k];
                }
            }
        } while (inc > 1);
        for (k = 0; k < n; ++k) {
            s = 0.0;
            for (i = 0; i < m; ++i) {
                if (!(u[i][k] < 0.0)) continue;
                s += 1.0;
            }
            for (j = 0; j < n; ++j) {
                if (!(v[j][k] < 0.0)) continue;
                s += 1.0;
            }
            if (!(s > (double)((m + n) / 2))) continue;
            for (i = 0; i < m; ++i) {
                u[i][k] = -u[i][k];
            }
            for (j = 0; j < n; ++j) {
                v[j][k] = -v[j][k];
            }
        }
        return new SingularValueDecomposition(u, v, w);
    }

    private static class ATA
    implements IMatrix {
        IMatrix A;
        double[] buf;

        public ATA(IMatrix A) {
            this.A = A;
            this.buf = A.nrows() >= A.ncols() ? new double[A.nrows()] : new double[A.ncols()];
        }

        public int nrows() {
            if (this.A.nrows() >= this.A.ncols()) {
                return this.A.ncols();
            }
            return this.A.nrows();
        }

        public int ncols() {
            return this.nrows();
        }

        public void ax(double[] x, double[] y) {
            if (this.A.nrows() >= this.A.ncols()) {
                this.A.ax(x, this.buf);
                this.A.atx(this.buf, y);
            } else {
                this.A.atx(x, this.buf);
                this.A.ax(this.buf, y);
            }
        }

        public void atx(double[] x, double[] y) {
            this.ax(x, y);
        }

        public void axpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        public void axpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }

        public double get(int i, int j) {
            throw new UnsupportedOperationException();
        }

        public void set(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public void asolve(double[] b, double[] x) {
            throw new UnsupportedOperationException();
        }

        public void atxpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        public void atxpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }
    }
}

