/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.Math;
import smile.math.special.Gamma;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.ExponentialFamily;
import smile.stat.distribution.GaussianDistribution;
import smile.stat.distribution.Mixture;

public class ChiSquareDistribution
extends AbstractDistribution
implements ExponentialFamily {
    private int nu;
    private double fac;
    private double entropy;

    public ChiSquareDistribution(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("Invalid nu: " + nu);
        }
        this.nu = nu;
        this.fac = 0.6931471805599453 * (0.5 * (double)nu) + Gamma.logGamma(0.5 * (double)nu);
        this.entropy = (double)nu / 2.0 + Math.log(2.0) + Gamma.logGamma((double)nu / 2.0) + (1.0 - (double)nu / 2.0) * Gamma.digamma((double)nu / 2.0);
    }

    public int getNu() {
        return this.nu;
    }

    public int npara() {
        return 1;
    }

    public double mean() {
        return this.nu;
    }

    public double var() {
        return 2 * this.nu;
    }

    public double sd() {
        return Math.sqrt(2 * this.nu);
    }

    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("ChiSquare Distribution(%d)", this.nu);
    }

    public double rand() {
        double x = 0.0;
        for (int i = 0; i < this.nu; ++i) {
            double norm = GaussianDistribution.getInstance().rand();
            x += norm * norm;
        }
        return x;
    }

    public double p(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(this.logp(x));
    }

    public double logp(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -0.5 * (x - ((double)this.nu - 2.0) * Math.log(x)) - this.fac;
    }

    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Gamma.regularizedIncompleteGamma((double)this.nu / 2.0, x / 2.0);
    }

    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return 2.0 * Gamma.inverseRegularizedIncompleteGamma(0.5 * (double)this.nu, p);
    }

    public Mixture.Component M(double[] x, double[] posteriori) {
        double alpha = 0.0;
        double mean = 0.0;
        for (int i = 0; i < x.length; ++i) {
            alpha += posteriori[i];
            mean += x[i] * posteriori[i];
        }
        Mixture.Component c = new Mixture.Component();
        c.priori = alpha;
        c.distribution = new ChiSquareDistribution((int)Math.round(mean /= alpha));
        return c;
    }
}

