/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.ArrayList;
import java.util.List;
import smile.math.Math;
import smile.stat.distribution.ExponentialFamilyMixture;
import smile.stat.distribution.GaussianDistribution;
import smile.stat.distribution.Mixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianMixture
extends ExponentialFamilyMixture {
    public GaussianMixture(List<Mixture.Component> mixture) {
        super(mixture);
    }

    public GaussianMixture(double[] data, int k) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of components in the mixture.");
        }
        double min = Math.min(data);
        double max = Math.max(data);
        double step = (max - min) / (double)(k + 1);
        for (int i = 0; i < k; ++i) {
            Mixture.Component c = new Mixture.Component();
            c.priori = 1.0 / (double)k;
            c.distribution = new GaussianDistribution(min += step, step);
            this.components.add(c);
        }
        this.EM(this.components, data);
    }

    public GaussianMixture(double[] data) {
        if (data.length < 20) {
            throw new IllegalArgumentException("Too few samples.");
        }
        ArrayList<Mixture.Component> mixture = new ArrayList<Mixture.Component>();
        Mixture.Component c = new Mixture.Component();
        c.priori = 1.0;
        c.distribution = new GaussianDistribution(data);
        mixture.add(c);
        int freedom = 0;
        for (int i = 0; i < mixture.size(); ++i) {
            freedom += ((Mixture.Component)mixture.get((int)i)).distribution.npara();
        }
        double bic = 0.0;
        for (double x : data) {
            double p = c.distribution.p(x);
            if (!(p > 0.0)) continue;
            bic += Math.log(p);
        }
        bic -= 0.5 * (double)freedom * Math.log(data.length);
        double b = Double.NEGATIVE_INFINITY;
        while (bic > b) {
            b = bic;
            this.components = (ArrayList)mixture.clone();
            this.split(mixture);
            bic = this.EM(mixture, data);
            freedom = 0;
            for (int i = 0; i < mixture.size(); ++i) {
                freedom += mixture.get((int)i).distribution.npara();
            }
            bic -= 0.5 * (double)freedom * Math.log(data.length);
        }
    }

    private void split(List<Mixture.Component> mixture) {
        Mixture.Component componentToSplit = null;
        double maxSigma = 0.0;
        for (Mixture.Component c : mixture) {
            if (!(c.distribution.sd() > maxSigma)) continue;
            maxSigma = c.distribution.sd();
            componentToSplit = c;
        }
        double delta = componentToSplit.distribution.sd();
        double mu = componentToSplit.distribution.mean();
        Mixture.Component c = new Mixture.Component();
        c.priori = componentToSplit.priori / 2.0;
        c.distribution = new GaussianDistribution(mu + delta / 2.0, delta);
        mixture.add(c);
        c = new Mixture.Component();
        c.priori = componentToSplit.priori / 2.0;
        c.distribution = new GaussianDistribution(mu - delta / 2.0, delta);
        mixture.add(c);
        mixture.remove(componentToSplit);
    }
}

