/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.Math;
import smile.math.special.Gamma;
import smile.stat.distribution.AbstractDistribution;

public class WeibullDistribution
extends AbstractDistribution {
    private double shape;
    private double scale;
    private double mean;
    private double var;
    private double entropy;

    public WeibullDistribution(double shape) {
        this(shape, 1.0);
    }

    public WeibullDistribution(double shape, double scale) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Invalid shape: " + shape);
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Invalid scale: " + scale);
        }
        this.shape = shape;
        this.scale = scale;
        this.mean = scale * Gamma.gamma(1.0 + 1.0 / shape);
        this.var = scale * scale * Gamma.gamma(1.0 + 2.0 / shape) - this.mean * this.mean;
        this.entropy = 0.5772156649015329 * (1.0 - 1.0 / shape) + Math.log(scale / shape) + 1.0;
    }

    public int npara() {
        return 2;
    }

    public double mean() {
        return this.mean;
    }

    public double var() {
        return this.var;
    }

    public double sd() {
        return Math.sqrt(this.var());
    }

    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Weibull Distribution(%.4f, %.4f)", this.shape, this.scale);
    }

    public double rand() {
        double r = Math.random();
        return this.scale * Math.pow(-Math.log(1.0 - r), 1.0 / this.shape);
    }

    public double p(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.shape / this.scale * Math.pow(x / this.scale, this.shape - 1.0) * Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    public double logp(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.shape / this.scale) + (this.shape - 1.0) * Math.log(x / this.scale) - Math.pow(x / this.scale, this.shape);
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return this.scale * Math.pow(-Math.log(1.0 - p), 1.0 / this.shape);
    }
}

