/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;

public class LUDecomposition {
    private DenseMatrix LU;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(double[][] A) {
        this(new ColumnMajorMatrix(A));
    }

    public LUDecomposition(DenseMatrix A) {
        int m = A.nrows();
        int n = A.ncols();
        this.LU = A;
        this.piv = new int[m];
        for (int i = 0; i < m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[m];
        for (int j = 0; j < n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < m; ++i2) {
                LUcolj[i2] = this.LU.get(i2, j);
            }
            for (i2 = 0; i2 < m; ++i2) {
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += this.LU.get(i2, k) * LUcolj[k];
                }
                int n2 = i2;
                LUcolj[n2] = LUcolj[n2] - s;
                this.LU.set(i2, j, LUcolj[i2]);
            }
            int p = j;
            for (i = j + 1; i < m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < n; ++k) {
                    double t = this.LU.get(p, k);
                    this.LU.set(p, k, this.LU.get(j, k));
                    this.LU.set(j, k, t);
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < m & this.LU.get(j, j) != 0.0)) continue;
            for (i = j + 1; i < m; ++i) {
                this.LU.div(i, j, this.LU.get(j, j));
            }
        }
    }

    public boolean isSingular() {
        int n = this.LU.ncols();
        for (int j = 0; j < n; ++j) {
            if (this.LU.get(j, j) != 0.0) continue;
            return true;
        }
        return false;
    }

    public DenseMatrix getL() {
        int m = this.LU.nrows();
        int n = this.LU.ncols();
        ColumnMajorMatrix L = new ColumnMajorMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            L.set(i, i, 1.0);
            for (int j = 0; j < i; ++j) {
                L.set(i, j, this.LU.get(i, j));
            }
        }
        return L;
    }

    public DenseMatrix getU() {
        int n = this.LU.ncols();
        ColumnMajorMatrix U = new ColumnMajorMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                U.set(i, j, this.LU.get(i, j));
            }
        }
        return U;
    }

    public int[] getPivot() {
        return this.piv;
    }

    public double det() {
        int n;
        int m = this.LU.nrows();
        if (m != (n = this.LU.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        double d = this.pivsign;
        for (int j = 0; j < n; ++j) {
            d *= this.LU.get(j, j);
        }
        return d;
    }

    public DenseMatrix inverse() {
        int n;
        int m = this.LU.nrows();
        if (m != (n = this.LU.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        ColumnMajorMatrix inv = new ColumnMajorMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            inv.set(i, this.piv[i], 1.0);
        }
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b) {
        this.solve((double[])b.clone(), b);
    }

    public void solve(double[] b, double[] x) {
        int i;
        int k;
        int n;
        int m = this.LU.nrows();
        if (m != (n = this.LU.ncols())) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        if (b.length != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1", this.LU.nrows(), this.LU.ncols(), b.length));
        }
        if (b.length != x.length) {
            throw new IllegalArgumentException("b and x dimensions do not agree.");
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        for (int i2 = 0; i2 < m; ++i2) {
            x[i2] = b[this.piv[i2]];
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                int n2 = i;
                x[n2] = x[n2] - x[k] * this.LU.get(i, k);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            int n3 = k;
            x[n3] = x[n3] / this.LU.get(k, k);
            for (i = 0; i < k; ++i) {
                int n4 = i;
                x[n4] = x[n4] - x[k] * this.LU.get(i, k);
            }
        }
    }

    public void solve(DenseMatrix B, DenseMatrix X) {
        int m = this.LU.nrows();
        int n = this.LU.ncols();
        if (X == B) {
            throw new IllegalArgumentException("B and X should not be the same object.");
        }
        if (X.nrows() != B.nrows() || X.ncols() != B.ncols()) {
            throw new IllegalArgumentException("B and X dimensions do not agree.");
        }
        int nx = B.ncols();
        for (int j = 0; j < nx; ++j) {
            for (int i = 0; i < m; ++i) {
                X.set(i, j, B.get(this.piv[i], j));
            }
        }
        this.solve(X);
    }

    private void solve(DenseMatrix X) {
        int j;
        int i;
        int k;
        int m = this.LU.nrows();
        int n = this.LU.ncols();
        int nx = X.ncols();
        if (X.nrows() != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.LU.nrows(), this.LU.ncols(), X.nrows(), X.ncols()));
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                for (j = 0; j < nx; ++j) {
                    X.sub(i, j, X.get(k, j) * this.LU.get(i, k));
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (int j2 = 0; j2 < nx; ++j2) {
                X.div(k, j2, this.LU.get(k, k));
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    X.sub(i, j, X.get(k, j) * this.LU.get(i, k));
                }
            }
        }
    }
}

