/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.MercerKernel;

public class BinarySparseLinearKernel
implements MercerKernel<int[]> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "Sparse Binary Linear Kernel";
    }

    @Override
    public double k(int[] x, int[] y) {
        int s = 0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < x.length && p2 < y.length) {
            int i1 = x[p1];
            int i2 = y[p2];
            if (i1 == i2) {
                ++s;
                ++p1;
                ++p2;
                continue;
            }
            if (i1 > i2) {
                ++p2;
                continue;
            }
            ++p1;
        }
        return s;
    }
}

