/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.MercerKernel;
import smile.util.SparseArray;

public class SparseHyperbolicTangentKernel
implements MercerKernel<SparseArray> {
    private static final long serialVersionUID = 1L;
    private double scale;
    private double offset;

    public SparseHyperbolicTangentKernel() {
        this(1.0, 0.0);
    }

    public SparseHyperbolicTangentKernel(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public String toString() {
        return String.format("Sparse Hyperbolic Tangent Kernel (scale = %.4f, offset = %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        double dot = MathEx.dot(x, y);
        return Math.tanh(this.scale * dot + this.offset);
    }
}

