/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.MathEx;
import smile.math.matrix.Cholesky;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.MatrixMultiplication;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;

public interface DenseMatrix
extends Matrix,
MatrixMultiplication<DenseMatrix, DenseMatrix> {
    public double[] data();

    default public int ld() {
        return this.nrows();
    }

    public void fill(double var1);

    public double set(int var1, int var2, double var3);

    default public double update(int i, int j, double x) {
        return this.set(i, j, x);
    }

    default public DenseMatrix apply(int i, int j, int k, int l) {
        return this.submat(i, j, k, l);
    }

    default public DenseMatrix submat(int i, int j, int k, int l) {
        int p = k - i;
        int q = l - j;
        DenseMatrix w = Matrix.zeros(p, q);
        for (int n = 0; n < q; ++n) {
            for (int m = 0; m < p; ++m) {
                w.set(m, n, this.get(i + m, j + n));
            }
        }
        return w;
    }

    public LU lu();

    default public LU lu(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.lu();
    }

    public Cholesky cholesky();

    default public Cholesky cholesky(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.cholesky();
    }

    public QR qr();

    default public QR qr(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.qr();
    }

    public SVD svd();

    default public SVD svd(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.svd();
    }

    public EVD eigen();

    default public EVD eigen(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.eigen();
    }

    public double[] eig();

    default public double[] eig(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.eig();
    }

    @Override
    public DenseMatrix transpose();

    default public DenseMatrix scale() {
        double[] center = this.colMeans();
        double[] scale = this.colSds();
        return this.scale(center, scale);
    }

    default public DenseMatrix scale(double[] center, double[] scale) {
        if (center == null && scale == null) {
            throw new IllegalArgumentException("Both center and scale are null");
        }
        int m = this.nrows();
        int n = this.ncols();
        DenseMatrix x = Matrix.zeros(m, n);
        if (center == null) {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < m; ++i) {
                    x.set(i, j, this.get(i, j) / scale[j]);
                }
            }
        } else if (scale == null) {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < m; ++i) {
                    x.set(i, j, this.get(i, j) - center[j]);
                }
            }
        } else {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < m; ++i) {
                    x.set(i, j, (this.get(i, j) - center[j]) / scale[j]);
                }
            }
        }
        return x;
    }

    default public DenseMatrix inverse() {
        return this.inverse(false);
    }

    default public DenseMatrix inverse(boolean inPlace) {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Call inverse() on a non-square matrix");
        }
        LU lu = this.lu(inPlace);
        return lu.inverse();
    }

    default public double norm1() {
        int m = this.nrows();
        int n = this.ncols();
        double f = 0.0;
        for (int j = 0; j < n; ++j) {
            double s = 0.0;
            for (int i = 0; i < m; ++i) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }

    default public double norm2() {
        return this.svd(false).norm();
    }

    default public double norm() {
        return this.norm2();
    }

    default public double normInf() {
        int m = this.nrows();
        int n = this.ncols();
        double[] f = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                f[n2] = f[n2] + Math.abs(this.get(i, j));
            }
        }
        return MathEx.max(f);
    }

    default public double normFro() {
        int m = this.nrows();
        int n = this.ncols();
        double f = 0.0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                f = Math.hypot(f, this.get(i, j));
            }
        }
        return f;
    }

    default public double xax(double[] x) {
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException("The matrix is not square");
        }
        if (this.nrows() != x.length) {
            throw new IllegalArgumentException("Matrix and vector size doesn't match for x' * A * x");
        }
        int n = x.length;
        double s = 0.0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n; ++i) {
                s += this.get(i, j) * x[i] * x[j];
            }
        }
        return s;
    }

    default public double[] rowSums() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        return x;
    }

    default public double[] rowMeans() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        int i = 0;
        while (i < m) {
            int n3 = i++;
            x[n3] = x[n3] / (double)n;
        }
        return x;
    }

    default public double[] rowSds() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[m];
        double[] x2 = new double[m];
        for (int j = 0; j < n; ++j) {
            int i = 0;
            while (i < m) {
                double a = this.get(i, j);
                int n2 = i;
                x[n2] = x[n2] + a;
                int n3 = i++;
                x2[n3] = x2[n3] + a * a;
            }
        }
        for (int i = 0; i < m; ++i) {
            double mu = x[i] / (double)n;
            x[i] = Math.sqrt(x2[i] / (double)n - mu * mu);
        }
        return x;
    }

    default public double[] colSums() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        return x;
    }

    default public double[] colMeans() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[n];
        int j = 0;
        while (j < n) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + this.get(i, j);
            }
            int n3 = j++;
            x[n3] = x[n3] / (double)m;
        }
        return x;
    }

    default public double[] colSds() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[n];
        for (int j = 0; j < n; ++j) {
            double mu = 0.0;
            double sumsq = 0.0;
            for (int i = 0; i < m; ++i) {
                double a = this.get(i, j);
                mu += a;
                sumsq += a * a;
            }
            x[j] = Math.sqrt(sumsq / (double)m - (mu /= (double)m) * mu);
        }
        return x;
    }

    public DenseMatrix copy();

    @Override
    public DenseMatrix ata();

    @Override
    public DenseMatrix aat();

    public double add(int var1, int var2, double var3);

    public double sub(int var1, int var2, double var3);

    public double mul(int var1, int var2, double var3);

    public double div(int var1, int var2, double var3);

    default public DenseMatrix add(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) + b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix add(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.add(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix sub(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) - b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix sub(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.sub(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix mul(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) * b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix mul(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.mul(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix div(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) / b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix div(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.div(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix add(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) + x);
            }
        }
        return c;
    }

    default public DenseMatrix add(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.add(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix sub(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) - x);
            }
        }
        return c;
    }

    default public DenseMatrix sub(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.sub(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix mul(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) * x);
            }
        }
        return c;
    }

    default public DenseMatrix mul(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.mul(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix div(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) / x);
            }
        }
        return c;
    }

    default public DenseMatrix div(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.div(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix replaceNaN(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                if (!Double.isNaN(this.get(i, j))) continue;
                this.set(i, j, x);
            }
        }
        return this;
    }

    default public double sum() {
        int m = this.nrows();
        int n = this.ncols();
        double s = 0.0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                s += this.get(i, j);
            }
        }
        return s;
    }

    default public double[][] toArray() {
        int m = this.nrows();
        int n = this.ncols();
        double[][] V = new double[m][n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                V[i][j] = this.get(i, j);
            }
        }
        return V;
    }
}

