/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class LU {
    protected DenseMatrix lu;
    protected int pivsign;
    protected int[] piv;
    protected boolean singular;

    public LU(DenseMatrix lu, int[] piv, int pivsign, boolean singular) {
        this.lu = lu;
        this.piv = piv;
        this.pivsign = pivsign;
        this.singular = singular;
    }

    public LU(DenseMatrix lu, int[] piv, boolean singular) {
        this.lu = lu;
        this.piv = piv;
        this.singular = singular;
        this.pivsign = 1;
        int n = Math.min(lu.nrows(), lu.ncols());
        for (int i = 0; i < n; ++i) {
            if (piv[i] == i) continue;
            this.pivsign = -this.pivsign;
        }
    }

    public DenseMatrix matrix() {
        return this.lu;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double det() {
        int n;
        int m = this.lu.nrows();
        if (m != (n = this.lu.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        double d = this.pivsign;
        for (int j = 0; j < n; ++j) {
            d *= this.lu.get(j, j);
        }
        return d;
    }

    public DenseMatrix inverse() {
        int n;
        int m = this.lu.nrows();
        if (m != (n = this.lu.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        DenseMatrix inv = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            inv.set(i, this.piv[i], 1.0);
        }
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b) {
        DenseMatrix B = Matrix.of(b);
        this.solve(B);
    }

    public void solve(DenseMatrix B) {
        int j;
        int k;
        int i;
        int j2;
        int m = this.lu.nrows();
        int n = this.lu.ncols();
        int nrhs = B.ncols();
        if (B.nrows() != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.lu.nrows(), this.lu.ncols(), B.nrows(), B.ncols()));
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        DenseMatrix X = Matrix.zeros(B.nrows(), B.ncols());
        for (j2 = 0; j2 < nrhs; ++j2) {
            for (i = 0; i < m; ++i) {
                X.set(i, j2, B.get(this.piv[i], j2));
            }
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                for (j = 0; j < nrhs; ++j) {
                    X.sub(i, j, X.get(k, j) * this.lu.get(i, k));
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (int j3 = 0; j3 < nrhs; ++j3) {
                X.div(k, j3, this.lu.get(k, k));
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nrhs; ++j) {
                    X.sub(i, j, X.get(k, j) * this.lu.get(i, k));
                }
            }
        }
        for (j2 = 0; j2 < nrhs; ++j2) {
            for (i = 0; i < m; ++i) {
                B.set(i, j2, X.get(i, j2));
            }
        }
    }
}

