/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.ATA;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Factory;
import smile.math.matrix.Lanczos;
import smile.math.matrix.SVD;
import smile.math.matrix.SparseMatrix;
import smile.stat.distribution.GaussianDistribution;
import smile.util.SparseArray;

public interface Matrix
extends Serializable {
    public static DenseMatrix of(double[][] A) {
        return Factory.matrix(A);
    }

    public static DenseMatrix of(double[] A) {
        return Factory.matrix(A);
    }

    public static DenseMatrix of(int rows, int cols, double value) {
        return Factory.matrix(rows, cols, value);
    }

    public static DenseMatrix zeros(int rows, int cols) {
        return Factory.matrix(rows, cols);
    }

    public static DenseMatrix ones(int rows, int cols) {
        return Factory.matrix(rows, cols, 1.0);
    }

    public static DenseMatrix eye(int n) {
        DenseMatrix matrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public static DenseMatrix eye(int m, int n) {
        DenseMatrix matrix = Factory.matrix(m, n);
        int k = Math.min(m, n);
        for (int i = 0; i < k; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public static DenseMatrix diag(double[] A) {
        int n = A.length;
        DenseMatrix matrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, A[i]);
        }
        return matrix;
    }

    public static DenseMatrix randn(int rows, int cols) {
        return Matrix.randn(rows, cols, 0.0, 1.0);
    }

    public static DenseMatrix randn(int rows, int cols, double mu, double sigma) {
        DenseMatrix a = Matrix.zeros(rows, cols);
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        for (int j = 0; j < cols; ++j) {
            for (int i = 0; i < rows; ++i) {
                a.set(i, j, g.rand());
            }
        }
        return a;
    }

    default public String toString(boolean full) {
        return full ? this.toString(this.nrows(), this.ncols()) : this.toString(7, 7);
    }

    default public String toString(int m, int n) {
        StringBuilder sb = new StringBuilder(this.nrows() + " x " + this.ncols() + "\n");
        m = Math.min(m, this.nrows());
        String newline = (n = Math.min(n, this.ncols())) < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%8.4f  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }

    default public boolean isSymmetric() {
        return false;
    }

    default public void setSymmetric(boolean symmetric) {
        throw new UnsupportedOperationException();
    }

    public int nrows();

    public int ncols();

    public Matrix transpose();

    public double get(int var1, int var2);

    default public double apply(int i, int j) {
        return this.get(i, j);
    }

    default public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    default public double trace() {
        int n = Math.min(this.nrows(), this.ncols());
        double t2 = 0.0;
        for (int i = 0; i < n; ++i) {
            t2 += this.get(i, i);
        }
        return t2;
    }

    public Matrix ata();

    public Matrix aat();

    public double[] ax(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2, double var3);

    public double[] atx(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2, double var3);

    default public EVD eigen(int k) {
        return this.eigen(k, 1.0E-8, 10 * this.nrows());
    }

    default public EVD eigen(int k, double kappa, int maxIter) {
        try {
            Class<?> clazz = Class.forName("smile.netlib.ARPACK");
            Method method = clazz.getMethod("eigen", Matrix.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
            return (EVD)method.invoke(null, this, k, "LA", kappa, maxIter);
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException)) {
                Logger logger = LoggerFactory.getLogger(Matrix.class);
                logger.info("Matrix.eigen({}, {}, {}):", new Object[]{k, kappa, maxIter, e});
            }
            return Lanczos.eigen(this, k, kappa, maxIter);
        }
    }

    default public SVD svd(int k) {
        return this.svd(k, 1.0E-8, 10 * this.nrows());
    }

    default public SVD svd(int k, double kappa, int maxIter) {
        int n;
        ATA B = new ATA(this);
        EVD eigen = Lanczos.eigen(B, k, kappa, maxIter);
        double[] s = eigen.getEigenValues();
        for (int i = 0; i < s.length; ++i) {
            s[i] = Math.sqrt(s[i]);
        }
        int m = this.nrows();
        if (m >= (n = this.ncols())) {
            DenseMatrix V = eigen.getEigenVectors();
            double[] tmp = new double[m];
            double[] vi = new double[n];
            DenseMatrix U = Matrix.zeros(m, s.length);
            for (int i = 0; i < s.length; ++i) {
                int j;
                for (j = 0; j < n; ++j) {
                    vi[j] = V.get(j, i);
                }
                this.ax(vi, tmp);
                for (j = 0; j < m; ++j) {
                    U.set(j, i, tmp[j] / s[i]);
                }
            }
            return new SVD(U, V, s);
        }
        DenseMatrix U = eigen.getEigenVectors();
        double[] tmp = new double[n];
        double[] ui = new double[m];
        DenseMatrix V = Matrix.zeros(n, s.length);
        for (int i = 0; i < s.length; ++i) {
            int j;
            for (j = 0; j < m; ++j) {
                ui[j] = U.get(j, i);
            }
            this.atx(ui, tmp);
            for (j = 0; j < n; ++j) {
                V.set(j, i, tmp[j] / s[i]);
            }
        }
        return new SVD(U, V, s);
    }

    public static Matrix market(Path path) throws IOException, ParseException {
        Throwable throwable = null;
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));){
            String format;
            Throwable throwable2;
            Scanner scanner;
            block48: {
                DenseMatrix denseMatrix;
                block49: {
                    block50: {
                        String line;
                        boolean symmetric;
                        block45: {
                            SparseMatrix sparseMatrix;
                            block46: {
                                block47: {
                                    int i;
                                    scanner = new Scanner(reader);
                                    throwable2 = null;
                                    String header = scanner.next();
                                    if (!header.equals("%%MatrixMarket")) {
                                        throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                    }
                                    String object = scanner.next();
                                    if (!object.equals("matrix")) {
                                        throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                    }
                                    format = scanner.next();
                                    String field = scanner.next();
                                    if (field.equals("complex") || field.equals("pattern")) {
                                        throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                    }
                                    String symmetry = scanner.nextLine().trim();
                                    symmetric = symmetry.equals("symmetric");
                                    boolean skew = symmetry.equals("skew-symmetric");
                                    line = scanner.nextLine();
                                    while (line.startsWith("%")) {
                                        line = scanner.nextLine();
                                    }
                                    if (!format.equals("coordinate")) break block45;
                                    Scanner s = new Scanner(line);
                                    int nrows = s.nextInt();
                                    int ncols = s.nextInt();
                                    int nz = s.nextInt();
                                    int[] colSize = new int[ncols];
                                    ArrayList<SparseArray> rows = new ArrayList<SparseArray>();
                                    for (int i2 = 0; i2 < nrows; ++i2) {
                                        rows.add(new SparseArray());
                                    }
                                    for (int k = 0; k < nz; ++k) {
                                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                                        if (tokens.length != 3) {
                                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                                        }
                                        i = Integer.parseInt(tokens[0]) - 1;
                                        int j = Integer.parseInt(tokens[1]) - 1;
                                        double x = Double.parseDouble(tokens[2]);
                                        SparseArray row = (SparseArray)rows.get(i);
                                        row.set(j, x);
                                        int n = j;
                                        colSize[n] = colSize[n] + 1;
                                        if (symmetric) {
                                            row = (SparseArray)rows.get(j);
                                            row.set(i, x);
                                            int n2 = i;
                                            colSize[n2] = colSize[n2] + 1;
                                            continue;
                                        }
                                        if (!skew) continue;
                                        row = (SparseArray)rows.get(j);
                                        row.set(i, -x);
                                        int n3 = i;
                                        colSize[n3] = colSize[n3] + 1;
                                    }
                                    int[] pos = new int[ncols];
                                    int[] colIndex = new int[ncols + 1];
                                    for (i = 0; i < ncols; ++i) {
                                        colIndex[i + 1] = colIndex[i] + colSize[i];
                                    }
                                    if (symmetric || skew) {
                                        nz *= 2;
                                    }
                                    int[] rowIndex = new int[nz];
                                    double[] x = new double[nz];
                                    for (int i3 = 0; i3 < nrows; ++i3) {
                                        for (SparseArray.Entry e : (SparseArray)rows.get(i3)) {
                                            int j = e.i;
                                            int k = colIndex[j] + pos[j];
                                            rowIndex[k] = i3;
                                            x[k] = e.x;
                                            int n = j;
                                            pos[n] = pos[n] + 1;
                                        }
                                    }
                                    SparseMatrix matrix = new SparseMatrix(nrows, ncols, x, rowIndex, colIndex);
                                    matrix.setSymmetric(symmetric);
                                    sparseMatrix = matrix;
                                    if (scanner == null) break block46;
                                    if (throwable2 == null) break block47;
                                    try {
                                        scanner.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block46;
                                }
                                scanner.close();
                            }
                            return sparseMatrix;
                        }
                        if (!format.equals("array")) break block48;
                        Scanner s = new Scanner(line);
                        int nrows = s.nextInt();
                        int ncols = s.nextInt();
                        DenseMatrix matrix = Matrix.of(nrows, ncols, 0.0);
                        matrix.setSymmetric(symmetric);
                        for (int j = 0; j < ncols; ++j) {
                            for (int i = 0; i < nrows; ++i) {
                                double x = scanner.nextDouble();
                                matrix.set(i, j, x);
                            }
                        }
                        denseMatrix = matrix;
                        if (scanner == null) break block49;
                        if (throwable2 == null) break block50;
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        break block49;
                    }
                    scanner.close();
                }
                return denseMatrix;
            }
            try {
                try {
                    try {
                        throw new ParseException("Invalid Matrix Market format: " + format, 0);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    if (scanner != null) {
                        if (throwable2 != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                        } else {
                            scanner.close();
                        }
                    }
                    throw throwable6;
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }
}

