/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.matrix.Matrix;

public class PowerIteration {
    private static final Logger logger = LoggerFactory.getLogger(PowerIteration.class);

    public static double eigen(Matrix A, double[] v) {
        return PowerIteration.eigen(A, v, Math.max(1.0E-10, (double)A.nrows() * MathEx.EPSILON));
    }

    public static double eigen(Matrix A, double[] v, double tol) {
        return PowerIteration.eigen(A, v, 0.0, tol);
    }

    public static double eigen(Matrix A, double[] v, double tol, int maxIter) {
        return PowerIteration.eigen(A, v, 0.0, tol, maxIter);
    }

    public static double eigen(Matrix A, double[] v, double p, double tol) {
        return PowerIteration.eigen(A, v, p, tol, Math.max(20, 2 * A.nrows()));
    }

    public static double eigen(Matrix A, double[] v, double p, double tol, int maxIter) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException("Matrix is not square.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = A.nrows();
        tol = Math.max(tol, MathEx.EPSILON * (double)n);
        double[] z = new double[n];
        double lambda = PowerIteration.ax(A, v, z, p);
        for (int iter = 1; iter <= maxIter; ++iter) {
            double l = lambda;
            lambda = PowerIteration.ax(A, v, z, p);
            double eps = Math.abs(lambda - l);
            if (iter % 10 == 0) {
                logger.trace(String.format("Largest eigenvalue after %3d power iterations: %.4f", iter, lambda + p));
            }
            if (!(eps < tol)) continue;
            logger.info(String.format("Largest eigenvalue after %3d power iterations: %.4f", iter, lambda + p));
            return lambda + p;
        }
        logger.info(String.format("Largest eigenvalue after %3d power iterations: %.4f", maxIter, lambda + p));
        logger.error("Power iteration exceeded the maximum number of iterations.");
        return lambda + p;
    }

    private static double ax(Matrix A, double[] x, double[] y, double p) {
        int i;
        A.ax(x, y);
        if (p != 0.0) {
            for (int i2 = 0; i2 < y.length; ++i2) {
                int n = i2;
                y[n] = y[n] - p * x[i2];
            }
        }
        double lambda = y[0];
        for (i = 1; i < y.length; ++i) {
            if (!(Math.abs(y[i]) > Math.abs(lambda))) continue;
            lambda = y[i];
        }
        for (i = 0; i < y.length; ++i) {
            x[i] = y[i] / lambda;
        }
        return lambda;
    }
}

