/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class QR {
    protected DenseMatrix qr;
    protected double[] tau;
    protected boolean singular;

    public QR(DenseMatrix qr, double[] tau, boolean singular) {
        this.qr = qr;
        this.tau = tau;
        this.singular = singular;
    }

    public DenseMatrix matrix() {
        return this.qr;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public Cholesky CholeskyOfAtA() {
        int n = this.qr.ncols();
        DenseMatrix L = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            L.set(i, i, this.tau[i]);
            for (int j = 0; j < i; ++j) {
                L.set(i, j, this.qr.get(j, i));
            }
        }
        return new Cholesky(L);
    }

    public DenseMatrix getR() {
        int n = this.qr.ncols();
        DenseMatrix R = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            R.set(i, i, this.tau[i]);
            for (int j = i + 1; j < n; ++j) {
                R.set(i, j, this.qr.get(i, j));
            }
        }
        return R;
    }

    public DenseMatrix getQ() {
        int m = this.qr.nrows();
        int n = this.qr.ncols();
        DenseMatrix Q = Matrix.zeros(m, n);
        for (int k = n - 1; k >= 0; --k) {
            Q.set(k, k, 1.0);
            for (int j = k; j < n; ++j) {
                int i;
                if (this.qr.get(k, k) == 0.0) continue;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.qr.get(i, k) * Q.get(i, j);
                }
                s = -s / this.qr.get(k, k);
                for (i = k; i < m; ++i) {
                    Q.add(i, j, s * this.qr.get(i, k));
                }
            }
        }
        return Q;
    }

    public void solve(double[] b, double[] x) {
        if (b.length != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x 1", this.qr.nrows(), this.qr.nrows(), b.length));
        }
        if (x.length != this.qr.ncols()) {
            throw new IllegalArgumentException("A and x dimensions don't match.");
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        double[] B = (double[])b.clone();
        this.solve(Matrix.of(B));
        System.arraycopy(B, 0, x, 0, x.length);
    }

    public void solve(DenseMatrix B) {
        int j;
        int k;
        if (B.nrows() != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.qr.nrows(), this.qr.nrows(), B.nrows(), B.ncols()));
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int m = this.qr.nrows();
        int n = this.qr.ncols();
        int nrhs = B.ncols();
        for (k = 0; k < n; ++k) {
            for (j = 0; j < nrhs; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.qr.get(i, k) * B.get(i, j);
                }
                s = -s / this.qr.get(k, k);
                for (i = k; i < m; ++i) {
                    B.add(i, j, s * this.qr.get(i, k));
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (j = 0; j < nrhs; ++j) {
                B.set(k, j, B.get(k, j) / this.tau[k]);
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nrhs; ++j2) {
                    B.sub(i, j2, B.get(k, j2) * this.qr.get(i, k));
                }
            }
        }
    }
}

