/*
 * Decompiled with CFR 0.152.
 */
package smile.stat;

import smile.math.MathEx;

public class Stat {
    private Stat() {
    }

    public static double bic(double L, int v, int n) {
        return L - 0.5 * (double)v * Math.log(n);
    }

    private static double smoothed(int x, double slope, double intercept) {
        return Math.exp(intercept + slope * Math.log(x));
    }

    private static int row(int[] r, int f) {
        int i;
        for (i = 0; i < r.length && r[i] < f; ++i) {
        }
        return i < r.length && r[i] == f ? i : -1;
    }

    public static double GoodTuring(int[] r, int[] Nr, double[] p) {
        int j;
        int i;
        double CONFID_FACTOR = 1.96;
        if (r.length != Nr.length) {
            throw new IllegalArgumentException("The sizes of r and Nr are not same.");
        }
        int len = r.length;
        double[] logR = new double[len];
        double[] logZ = new double[len];
        double[] Z = new double[len];
        int N = 0;
        for (int j2 = 0; j2 < len; ++j2) {
            N += r[j2] * Nr[j2];
        }
        int n1 = r[0] != 1 ? 0 : Nr[0];
        double p0 = (double)n1 / (double)N;
        for (int j3 = 0; j3 < len; ++j3) {
            int q = j3 == 0 ? 0 : r[j3 - 1];
            int t2 = j3 == len - 1 ? 2 * r[j3] - q : r[j3 + 1];
            Z[j3] = 2.0 * (double)Nr[j3] / (double)(t2 - q);
            logR[j3] = Math.log(r[j3]);
            logZ[j3] = Math.log(Z[j3]);
        }
        double XYs = 0.0;
        double Xsquares = 0.0;
        double meanX = 0.0;
        double meanY = 0.0;
        for (i = 0; i < len; ++i) {
            meanX += logR[i];
            meanY += logZ[i];
        }
        meanX /= (double)len;
        meanY /= (double)len;
        for (i = 0; i < len; ++i) {
            XYs += (logR[i] - meanX) * (logZ[i] - meanY);
            Xsquares += MathEx.sqr(logR[i] - meanX);
        }
        double slope = XYs / Xsquares;
        double intercept = meanY - slope * meanX;
        boolean indiffValsSeen = false;
        for (int j4 = 0; j4 < len; ++j4) {
            double y = (double)(r[j4] + 1) * Stat.smoothed(r[j4] + 1, slope, intercept) / Stat.smoothed(r[j4], slope, intercept);
            if (Stat.row(r, r[j4] + 1) < 0) {
                indiffValsSeen = true;
            }
            if (!indiffValsSeen) {
                int n = Nr[Stat.row(r, r[j4] + 1)];
                double x = (double)((r[j4] + 1) * n) / (double)Nr[j4];
                if (Math.abs(x - y) <= 1.96 * Math.sqrt(MathEx.sqr((double)r[j4] + 1.0) * (double)n / MathEx.sqr(Nr[j4]) * (1.0 + (double)n / (double)Nr[j4]))) {
                    indiffValsSeen = true;
                } else {
                    p[j4] = x;
                }
            }
            if (!indiffValsSeen) continue;
            p[j4] = y;
        }
        double Nprime = 0.0;
        for (j = 0; j < len; ++j) {
            Nprime += (double)Nr[j] * p[j];
        }
        for (j = 0; j < len; ++j) {
            p[j] = (1.0 - p0) * p[j] / Nprime;
        }
        return p0;
    }
}

