/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.blas.Transpose;
import smile.math.matrix.DoubleConsumer;
import smile.math.matrix.FloatConsumer;
import smile.math.matrix.SMatrix;
import smile.math.matrix.SparseMatrix;
import smile.util.Strings;

public class FloatSparseMatrix
extends SMatrix
implements Iterable<Entry> {
    private static final Logger logger = LoggerFactory.getLogger(SparseMatrix.class);
    private static final long serialVersionUID = 2L;
    private final int m;
    private final int n;
    private final int[] colIndex;
    private final int[] rowIndex;
    private final float[] nonzeros;

    private FloatSparseMatrix(int m, int n, int nvals) {
        this.m = m;
        this.n = n;
        this.rowIndex = new int[nvals];
        this.colIndex = new int[n + 1];
        this.nonzeros = new float[nvals];
    }

    public FloatSparseMatrix(int m, int n, float[] nonzeros, int[] rowIndex, int[] colIndex) {
        this.m = m;
        this.n = n;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.nonzeros = nonzeros;
    }

    public FloatSparseMatrix(float[][] A) {
        this(A, 100.0f * MathEx.FLOAT_EPSILON);
    }

    public FloatSparseMatrix(float[][] A, float tol) {
        int j;
        this.m = A.length;
        this.n = A[0].length;
        int nvals = 0;
        for (int i = 0; i < this.m; ++i) {
            for (j = 0; j < this.n; ++j) {
                if (!(Math.abs(A[i][j]) >= tol)) continue;
                ++nvals;
            }
        }
        this.nonzeros = new float[nvals];
        this.rowIndex = new int[nvals];
        this.colIndex = new int[this.n + 1];
        this.colIndex[this.n] = nvals;
        int k = 0;
        for (j = 0; j < this.n; ++j) {
            this.colIndex[j] = k;
            for (int i = 0; i < this.m; ++i) {
                if (!(Math.abs(A[i][j]) >= tol)) continue;
                this.rowIndex[k] = i;
                this.nonzeros[k] = A[i][j];
                ++k;
            }
        }
    }

    public FloatSparseMatrix clone() {
        return new FloatSparseMatrix(this.m, this.n, (float[])this.nonzeros.clone(), (int[])this.rowIndex.clone(), (int[])this.colIndex.clone());
    }

    @Override
    public int nrows() {
        return this.m;
    }

    @Override
    public int ncols() {
        return this.n;
    }

    @Override
    public long size() {
        return this.colIndex[this.n];
    }

    public Stream<Entry> nonzeros() {
        Spliterator<Entry> spliterator = Spliterators.spliterator(this.iterator(), this.size(), 1104);
        return StreamSupport.stream(spliterator, false);
    }

    public Stream<Entry> nonzeros(int beginColumn, int endColumn) {
        Spliterator<Entry> spliterator = Spliterators.spliterator(this.iterator(beginColumn, endColumn), (long)(this.colIndex[endColumn] - this.colIndex[beginColumn]), 1104);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.iterator(0, this.n);
    }

    public Iterator<Entry> iterator(final int beginColumn, final int endColumn) {
        if (beginColumn < 0 || beginColumn >= this.n) {
            throw new IllegalArgumentException("Invalid begin column: " + beginColumn);
        }
        if (endColumn <= beginColumn || endColumn > this.n) {
            throw new IllegalArgumentException("Invalid end column: " + endColumn);
        }
        return new Iterator<Entry>(){
            int k;
            int j;
            {
                this.k = FloatSparseMatrix.this.colIndex[beginColumn];
                this.j = beginColumn;
            }

            @Override
            public boolean hasNext() {
                return this.k < FloatSparseMatrix.this.colIndex[endColumn];
            }

            @Override
            public Entry next() {
                int i = FloatSparseMatrix.this.rowIndex[this.k];
                while (this.k >= FloatSparseMatrix.this.colIndex[this.j + 1]) {
                    ++this.j;
                }
                return new Entry(i, this.j, this.k++);
            }
        };
    }

    public void forEachNonZero(DoubleConsumer consumer) {
        for (int j = 0; j < this.n; ++j) {
            for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
                int i = this.rowIndex[k];
                consumer.accept(i, j, this.nonzeros[k]);
            }
        }
    }

    public void forEachNonZero(int beginColumn, int endColumn, FloatConsumer consumer) {
        if (beginColumn < 0 || beginColumn >= this.n) {
            throw new IllegalArgumentException("Invalid begin column: " + beginColumn);
        }
        if (endColumn <= beginColumn || endColumn > this.n) {
            throw new IllegalArgumentException("Invalid end column: " + endColumn);
        }
        for (int j = beginColumn; j < endColumn; ++j) {
            for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
                int i = this.rowIndex[k];
                consumer.accept(i, j, this.nonzeros[k]);
            }
        }
    }

    public float get(int index) {
        return this.nonzeros[index];
    }

    public float set(int index, float value) {
        this.nonzeros[index] = value;
        return this.nonzeros[index];
    }

    @Override
    public float get(int i, int j) {
        if (i < 0 || i >= this.m || j < 0 || j >= this.n) {
            throw new IllegalArgumentException("Invalid index: row = " + i + " col = " + j);
        }
        for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
            if (this.rowIndex[k] != i) continue;
            return this.nonzeros[k];
        }
        return 0.0f;
    }

    @Override
    public FloatSparseMatrix set(int i, int j, float x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mv(Transpose trans, float alpha, float[] x, float beta, float[] y) {
        int i;
        int k = trans == Transpose.NO_TRANSPOSE ? this.m : this.n;
        float[] ax = y;
        if (beta == 0.0f) {
            Arrays.fill(y, 0.0f);
        } else {
            ax = new float[k];
        }
        if (trans == Transpose.NO_TRANSPOSE) {
            for (int j = 0; j < this.n; ++j) {
                for (int i2 = this.colIndex[j]; i2 < this.colIndex[j + 1]; ++i2) {
                    int n = this.rowIndex[i2];
                    ax[n] = ax[n] + this.nonzeros[i2] * x[j];
                }
            }
        } else {
            for (i = 0; i < this.n; ++i) {
                for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                    int n = i;
                    ax[n] = ax[n] + this.nonzeros[j] * x[this.rowIndex[j]];
                }
            }
        }
        if ((double)beta != 0.0 || (double)alpha != 1.0) {
            for (i = 0; i < k; ++i) {
                y[i] = alpha * ax[i] + beta * y[i];
            }
        }
    }

    @Override
    public void mv(float[] work, int inputOffset, int outputOffset) {
        Arrays.fill(work, outputOffset, outputOffset + this.m, 0.0f);
        for (int j = 0; j < this.n; ++j) {
            for (int i = this.colIndex[j]; i < this.colIndex[j + 1]; ++i) {
                int n = outputOffset + this.rowIndex[i];
                work[n] = work[n] + this.nonzeros[i] * work[inputOffset + j];
            }
        }
    }

    @Override
    public void tv(float[] work, int inputOffset, int outputOffset) {
        Arrays.fill(work, outputOffset, outputOffset + this.n, 0.0f);
        for (int i = 0; i < this.n; ++i) {
            for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                int n = outputOffset + i;
                work[n] = work[n] + this.nonzeros[j] * work[inputOffset + this.rowIndex[j]];
            }
        }
    }

    public FloatSparseMatrix transpose() {
        int k;
        int j;
        int i;
        FloatSparseMatrix trans = new FloatSparseMatrix(this.n, this.m, this.nonzeros.length);
        int[] count = new int[this.m];
        for (i = 0; i < this.n; ++i) {
            for (j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                int n = k = this.rowIndex[j];
                count[n] = count[n] + 1;
            }
        }
        for (int j2 = 0; j2 < this.m; ++j2) {
            trans.colIndex[j2 + 1] = trans.colIndex[j2] + count[j2];
        }
        Arrays.fill(count, 0);
        for (i = 0; i < this.n; ++i) {
            for (j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                k = this.rowIndex[j];
                int index = trans.colIndex[k] + count[k];
                trans.rowIndex[index] = i;
                trans.nonzeros[index] = this.nonzeros[j];
                int n = k;
                count[n] = count[n] + 1;
            }
        }
        return trans;
    }

    public FloatSparseMatrix mm(FloatSparseMatrix B) {
        if (this.n != B.m) {
            throw new IllegalArgumentException(String.format("Matrix dimensions do not match for matrix multiplication: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        int n = B.n;
        int anz = this.colIndex[n];
        int[] Bp = B.colIndex;
        int[] Bi = B.rowIndex;
        float[] Bx = B.nonzeros;
        int bnz = Bp[n];
        int[] w = new int[this.m];
        float[] abj = new float[this.m];
        int nzmax = Math.max(anz + bnz, this.m);
        FloatSparseMatrix C = new FloatSparseMatrix(this.m, n, nzmax);
        int[] Cp = C.colIndex;
        int[] Ci = C.rowIndex;
        float[] Cx = C.nonzeros;
        int nz = 0;
        for (int j = 0; j < n; ++j) {
            int p;
            if (nz + this.m > nzmax) {
                nzmax = 2 * nzmax + this.m;
                float[] Cx2 = new float[nzmax];
                int[] Ci2 = new int[nzmax];
                System.arraycopy(Ci, 0, Ci2, 0, nz);
                System.arraycopy(Cx, 0, Cx2, 0, nz);
                Ci = Ci2;
                Cx = Cx2;
                C = new FloatSparseMatrix(this.m, n, Cx2, Ci2, Cp);
            }
            Cp[j] = nz;
            for (p = Bp[j]; p < Bp[j + 1]; ++p) {
                nz = FloatSparseMatrix.scatter(this, Bi[p], Bx[p], w, abj, j + 1, C, nz);
            }
            for (p = Cp[j]; p < nz; ++p) {
                Cx[p] = abj[Ci[p]];
            }
        }
        Cp[n] = nz;
        return C;
    }

    private static int scatter(FloatSparseMatrix A, int j, float beta, int[] w, float[] x, int mark, FloatSparseMatrix C, int nz) {
        int[] Ap = A.colIndex;
        int[] Ai = A.rowIndex;
        float[] Ax = A.nonzeros;
        int[] Ci = C.rowIndex;
        for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
            int i = Ai[p];
            if (w[i] < mark) {
                w[i] = mark;
                Ci[nz++] = i;
                x[i] = beta * Ax[p];
                continue;
            }
            int n = i;
            x[n] = x[n] + beta * Ax[p];
        }
        return nz;
    }

    public FloatSparseMatrix ata() {
        FloatSparseMatrix AT = this.transpose();
        return AT.aat(this);
    }

    public FloatSparseMatrix aat() {
        FloatSparseMatrix AT = this.transpose();
        return this.aat(AT);
    }

    private FloatSparseMatrix aat(FloatSparseMatrix AT) {
        int i;
        int j;
        int i2;
        int[] done = new int[this.m];
        for (int i3 = 0; i3 < this.m; ++i3) {
            done[i3] = -1;
        }
        int nvals = 0;
        for (int j2 = 0; j2 < this.m; ++j2) {
            for (i2 = AT.colIndex[j2]; i2 < AT.colIndex[j2 + 1]; ++i2) {
                int k = AT.rowIndex[i2];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h = this.rowIndex[l];
                    if (done[h] == j2) continue;
                    done[h] = j2;
                    ++nvals;
                }
            }
        }
        FloatSparseMatrix aat = new FloatSparseMatrix(this.m, this.m, nvals);
        nvals = 0;
        for (i2 = 0; i2 < this.m; ++i2) {
            done[i2] = -1;
        }
        for (j = 0; j < this.m; ++j) {
            aat.colIndex[j] = nvals;
            for (i = AT.colIndex[j]; i < AT.colIndex[j + 1]; ++i) {
                int k = AT.rowIndex[i];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h = this.rowIndex[l];
                    if (done[h] == j) continue;
                    done[h] = j;
                    aat.rowIndex[nvals] = h;
                    ++nvals;
                }
            }
        }
        aat.colIndex[this.m] = nvals;
        for (j = 0; j < this.m; ++j) {
            if (aat.colIndex[j + 1] - aat.colIndex[j] <= 1) continue;
            Arrays.sort(aat.rowIndex, aat.colIndex[j], aat.colIndex[j + 1]);
        }
        float[] temp = new float[this.m];
        for (i = 0; i < this.m; ++i) {
            int k;
            int j3;
            for (j3 = AT.colIndex[i]; j3 < AT.colIndex[i + 1]; ++j3) {
                k = AT.rowIndex[j3];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h;
                    int n = h = this.rowIndex[l];
                    temp[n] = temp[n] + AT.nonzeros[j3] * this.nonzeros[l];
                }
            }
            for (j3 = aat.colIndex[i]; j3 < aat.colIndex[i + 1]; ++j3) {
                k = aat.rowIndex[j3];
                aat.nonzeros[j3] = temp[k];
                temp[k] = 0.0f;
            }
        }
        return aat;
    }

    @Override
    public float[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        float[] d = new float[n];
        block0: for (int i = 0; i < n; ++i) {
            for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                if (this.rowIndex[j] != i) continue;
                d[i] = this.nonzeros[j];
                continue block0;
            }
        }
        return d;
    }

    /*
     * Exception decompiling
     */
    public static FloatSparseMatrix harwell(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static FloatSparseMatrix rutherford(Path path) throws IOException {
        return FloatSparseMatrix.harwell(path);
    }

    /*
     * Exception decompiling
     */
    public static FloatSparseMatrix text(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public class Entry {
        public final int i;
        public final int j;
        public final float x;
        public final int index;

        private Entry(int i, int j, int index) {
            this.i = i;
            this.j = j;
            this.x = FloatSparseMatrix.this.nonzeros[index];
            this.index = index;
        }

        public void update(float value) {
            ((FloatSparseMatrix)FloatSparseMatrix.this).nonzeros[this.index] = value;
        }

        public String toString() {
            return String.format("(%d, %d):%s", this.i, this.j, Strings.format(this.x));
        }
    }
}

