/*
 * Decompiled with CFR 0.152.
 */
package smile.stat;

import smile.stat.distribution.Distribution;
import smile.stat.hypothesis.ChiSqTest;
import smile.stat.hypothesis.CorTest;
import smile.stat.hypothesis.FTest;
import smile.stat.hypothesis.KSTest;
import smile.stat.hypothesis.TTest;

public interface Hypothesis {
    public static String significance(double pvalue) {
        if (pvalue < 0.001) {
            return "***";
        }
        if (pvalue < 0.01) {
            return "**";
        }
        if (pvalue < 0.05) {
            return "*";
        }
        if (pvalue < 0.1) {
            return ".";
        }
        return "";
    }

    public static interface chisq {
        public static ChiSqTest test(int[] bins, double[] prob) {
            return chisq.test(bins, prob, 1);
        }

        public static ChiSqTest test(int[] bins, double[] prob, int constraints) {
            return ChiSqTest.test(bins, prob, constraints);
        }

        public static ChiSqTest test(int[] bins1, int[] bins2) {
            return chisq.test(bins1, bins2, 1);
        }

        public static ChiSqTest test(int[] bins1, int[] bins2, int constraints) {
            return ChiSqTest.test(bins1, bins2, constraints);
        }

        public static ChiSqTest test(int[][] table) {
            return ChiSqTest.test(table);
        }
    }

    public static interface cor {
        public static CorTest test(double[] x, double[] y) {
            return CorTest.pearson(x, y);
        }

        public static CorTest test(double[] x, double[] y, String method) {
            switch (method) {
                case "pearson": {
                    return CorTest.pearson(x, y);
                }
                case "kendall": {
                    return CorTest.kendall(x, y);
                }
                case "spearman": {
                    return CorTest.spearman(x, y);
                }
            }
            throw new IllegalArgumentException("Invalid correlation test method: " + method);
        }
    }

    public static interface KS {
        public static KSTest test(double[] x, Distribution dist) {
            return KSTest.test(x, dist);
        }

        public static KSTest test(double[] x, double[] y) {
            return KSTest.test(x, y);
        }
    }

    public static interface F {
        public static FTest test(double[] x, double[] y) {
            return FTest.test(x, y);
        }
    }

    public static interface t {
        public static TTest test(double[] x, double mean) {
            return TTest.test(x, mean);
        }

        public static TTest test(double[] x, double[] y) {
            return TTest.test(x, y, false);
        }

        public static TTest test(double[] x, double[] y, String option) {
            switch (option) {
                case "unequal.var": {
                    return TTest.test(x, y, false);
                }
                case "equal.var": {
                    return TTest.test(x, y, true);
                }
                case "paired": {
                    return TTest.testPaired(x, y);
                }
            }
            return TTest.testPaired(x, y);
        }

        public static TTest test(double r, int df) {
            return TTest.test(r, df);
        }
    }
}

