/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.stat.distribution.AbstractDistribution;

public abstract class DiscreteDistribution
extends AbstractDistribution {
    public int randi() {
        return (int)this.rand();
    }

    public int[] randi(int n) {
        int[] data = new int[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.randi();
        }
        return data;
    }

    public abstract double p(int var1);

    @Override
    public double p(double x) {
        if (!MathEx.isInt(x)) {
            throw new IllegalArgumentException("x is not an integer");
        }
        return this.p((int)x);
    }

    public abstract double logp(int var1);

    @Override
    public double logp(double x) {
        if (!MathEx.isInt(x)) {
            throw new IllegalArgumentException("x is not an integer");
        }
        return this.logp((int)x);
    }

    public double likelihood(int[] x) {
        return Math.exp(this.logLikelihood(x));
    }

    public double logLikelihood(int[] x) {
        double L = 0.0;
        int[] nArray = x;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double xi = nArray[i];
            L += this.logp(xi);
        }
        return L;
    }

    protected double quantile(double p, int xmin, int xmax) {
        while (xmax - xmin > 1) {
            int xmed = (xmax + xmin) / 2;
            if (this.cdf(xmed) > p) {
                xmax = xmed;
                continue;
            }
            xmin = xmed;
        }
        if (this.cdf(xmin) >= p) {
            return xmin;
        }
        return xmax;
    }
}

