/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Function;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;

public interface IsotropicKernel
extends Function {
    @Override
    default public double f(double dist) {
        return this.k(dist);
    }

    public double k(double var1);

    public double[] kg(double var1);

    @Override
    default public double apply(double dist) {
        return this.k(dist);
    }

    default public Matrix K(Matrix pdist) {
        if (pdist.nrows() != pdist.ncols()) {
            throw new IllegalArgumentException(String.format("pdist is not square: %d x %d", pdist.nrows(), pdist.ncols()));
        }
        int n = pdist.nrows();
        Matrix K = new Matrix(n, n);
        for (int j = 0; j < n; ++j) {
            K.set(j, j, this.k(pdist.get(j, j)));
            for (int i = j + 1; i < n; ++i) {
                double k = this.k(pdist.get(i, j));
                K.set(i, j, k);
                K.set(j, i, k);
            }
        }
        K.uplo(UPLO.LOWER);
        return K;
    }

    default public Matrix[] KG(Matrix pdist) {
        if (pdist.nrows() != pdist.ncols()) {
            throw new IllegalArgumentException(String.format("pdist is not square: %d x %d", pdist.nrows(), pdist.ncols()));
        }
        int n = pdist.nrows();
        int m = this.kg(pdist.get(0, 0)).length;
        Matrix[] K = new Matrix[m];
        for (int i = 0; i < m; ++i) {
            K[i] = new Matrix(n, n);
            K[i].uplo(UPLO.LOWER);
        }
        for (int j = 0; j < n; ++j) {
            double[] kg = this.kg(pdist.get(j, j));
            for (int l = 0; l < m; ++l) {
                K[l].set(j, j, kg[l]);
            }
            for (int i = j + 1; i < n; ++i) {
                kg = this.kg(pdist.get(i, j));
                for (int l = 0; l < m; ++l) {
                    K[l].set(i, j, kg[l]);
                    K[l].set(j, i, kg[l]);
                }
            }
        }
        return K;
    }
}

