/*
 * Decompiled with CFR 0.152.
 */
package smile.netlib;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import org.netlib.util.intW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.JMatrix;
import smile.math.matrix.SVD;
import smile.netlib.Cholesky;
import smile.netlib.LU;
import smile.netlib.QR;

public class NLMatrix
extends JMatrix {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NLMatrix.class);
    static String NoTranspose = "N";
    static String Transpose = "T";
    static String ConjugateTranspose = "C";
    static String Upper = "U";
    static String Lower = "L";
    static String Left = "L";
    static String Right = "R";
    static String UnitTriangular = "U";
    static String NonUnitTriangular = "N";

    public NLMatrix(double[][] A) {
        super(A);
    }

    public NLMatrix(double[] A) {
        super(A);
    }

    public NLMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public NLMatrix(int rows, int cols, double value) {
        super(rows, cols, value);
    }

    public NLMatrix(int rows, int cols, double[] value) {
        super(rows, cols, value);
    }

    public NLMatrix copy() {
        return new NLMatrix(this.nrows(), this.ncols(), (double[])this.data().clone());
    }

    public double[] ax(double[] x, double[] y) {
        BLAS.getInstance().dgemv(NoTranspose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, 0.0, y, 1);
        return y;
    }

    public double[] axpy(double[] x, double[] y) {
        BLAS.getInstance().dgemv(NoTranspose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, 1.0, y, 1);
        return y;
    }

    public double[] axpy(double[] x, double[] y, double b) {
        BLAS.getInstance().dgemv(NoTranspose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, b, y, 1);
        return y;
    }

    public double[] atx(double[] x, double[] y) {
        BLAS.getInstance().dgemv(Transpose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, 0.0, y, 1);
        return y;
    }

    public double[] atxpy(double[] x, double[] y) {
        BLAS.getInstance().dgemv(Transpose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, 1.0, y, 1);
        return y;
    }

    public double[] atxpy(double[] x, double[] y, double b) {
        BLAS.getInstance().dgemv(Transpose, this.nrows(), this.ncols(), 1.0, this.data(), this.ld(), x, 1, b, y, 1);
        return y;
    }

    public NLMatrix ata() {
        return this.atbmm((DenseMatrix)this);
    }

    public NLMatrix aat() {
        return this.abtmm((DenseMatrix)this);
    }

    public NLMatrix abmm(DenseMatrix B) {
        if (B instanceof JMatrix) {
            int m = this.nrows();
            int n = B.ncols();
            int k = this.ncols();
            NLMatrix C = new NLMatrix(m, n);
            BLAS.getInstance().dgemm(NoTranspose, NoTranspose, m, n, k, 1.0, this.data(), m, B.data(), k, 0.0, C.data(), m);
            return C;
        }
        throw new IllegalArgumentException("NLMatrix.abmm() parameter must be JMatrix");
    }

    public NLMatrix abtmm(DenseMatrix B) {
        if (B instanceof JMatrix) {
            int m = this.nrows();
            int n = B.nrows();
            int k = this.ncols();
            NLMatrix C = new NLMatrix(m, n);
            BLAS.getInstance().dgemm(NoTranspose, Transpose, m, n, k, 1.0, this.data(), m, B.data(), n, 0.0, C.data(), m);
            return C;
        }
        throw new IllegalArgumentException("NLMatrix.abtmm() parameter must be JMatrix");
    }

    public NLMatrix atbmm(DenseMatrix B) {
        if (B instanceof JMatrix) {
            int m = this.ncols();
            int n = B.ncols();
            int k = this.nrows();
            NLMatrix C = new NLMatrix(m, n);
            BLAS.getInstance().dgemm(Transpose, NoTranspose, m, n, k, 1.0, this.data(), k, B.data(), k, 0.0, C.data(), m);
            return C;
        }
        throw new IllegalArgumentException("NLMatrix.atbmm() parameter must be JMatrix");
    }

    public NLMatrix transpose() {
        NLMatrix B = new NLMatrix(this.ncols(), this.nrows());
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                B.set(j, i, this.get(i, j));
            }
        }
        return B;
    }

    public LU lu() {
        boolean singular = false;
        int[] piv = new int[Math.min(this.nrows(), this.ncols())];
        intW info = new intW(0);
        LAPACK.getInstance().dgetrf(this.nrows(), this.ncols(), this.data(), this.ld(), piv, info);
        if (info.val > 0) {
            singular = true;
        }
        if (info.val < 0) {
            logger.error("LAPACK DGETRF error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGETRF error code: " + info.val);
        }
        return new LU((DenseMatrix)this, piv, singular);
    }

    public Cholesky cholesky() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Cholesky decomposition on non-square matrix");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dpotrf(Lower, this.nrows(), this.data(), this.ld(), info);
        if (info.val > 0) {
            logger.error("LAPACK DPOTRF error code: {}", (Object)info.val);
            throw new IllegalArgumentException("The matrix is not positive definite.");
        }
        if (info.val < 0) {
            logger.error("LAPACK DPOTRF error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DPOTRF error code: " + info.val);
        }
        return new Cholesky((DenseMatrix)this);
    }

    public QR qr() {
        boolean singular = false;
        int m = this.nrows();
        int n = this.ncols();
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeqrf(m, n, new double[0], m, new double[0], work, -1, info);
        int lwork = n;
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.info("LAPACK DEGQRF returns work space size: {}", (Object)lwork);
        } else {
            logger.info("LAPACK DEGQRF error code: {}", (Object)info.val);
        }
        lwork = Math.max(1, lwork);
        work = new double[lwork];
        info.val = 0;
        double[] tau = new double[Math.min(this.nrows(), this.ncols())];
        LAPACK.getInstance().dgeqrf(this.nrows(), this.ncols(), this.data(), this.ld(), tau, work, lwork, info);
        if (info.val > 0) {
            singular = true;
        }
        if (info.val < 0) {
            logger.error("LAPACK DGETRF error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGETRF error code: " + info.val);
        }
        return new QR((DenseMatrix)this, tau, singular);
    }

    public SVD svd() {
        int m = this.nrows();
        int n = this.ncols();
        int mx = Math.max(m, n);
        int mn = Math.min(m, n);
        NLMatrix U = m >= n ? this : new NLMatrix(m, n);
        NLMatrix Vt = m >= n ? new NLMatrix(n, n) : this;
        double[] s = new double[mn];
        int[] iwork = new int[8 * mn];
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgesdd("O", m, n, this.data(), this.ld(), s, U.data(), U.ld(), Vt.data(), Vt.ld(), work, -1, iwork, info);
        int lwork = 3 * mn + Math.max(mx, 5 * mn * mn + 4 * mn);
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.info("LAPACK DGESDD returns work space size: {}", (Object)lwork);
        } else {
            logger.info("LAPACK DGESDD error code: {}", (Object)info.val);
        }
        lwork = Math.max(1, lwork);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgesdd("O", m, n, this.data(), this.ld(), s, U.data(), U.ld(), Vt.data(), Vt.ld(), work, lwork, iwork, info);
        if (info.val != 0) {
            logger.error("LAPACK DGESDD error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGESDD error code: " + info.val);
        }
        return new SVD((DenseMatrix)U, (DenseMatrix)Vt.transpose(), s);
    }

    public double[] eig() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Eigen decomposition on non-square matrix");
        }
        int n = this.nrows();
        if (this.isSymmetric()) {
            double[] V = new double[]{};
            double[] d = new double[n];
            double abstol = LAPACK.getInstance().dlamch("Safe minimum");
            int[] isuppz = new int[2 * Math.max(1, n)];
            double[] work = new double[1];
            int[] iwork = new int[1];
            intW m = new intW(0);
            intW info = new intW(0);
            LAPACK.getInstance().dsyevr("N", "A", Lower, n, this.data(), this.ld(), 0.0, 0.0, 0, 0, abstol, m, d, V, 1, isuppz, work, -1, iwork, -1, info);
            int lwork = 26 * n;
            int liwork = 10 * n;
            if (info.val == 0) {
                lwork = (int)work[0];
                liwork = iwork[0];
                logger.info("LAPACK DSYEVR returns work space size: {}", (Object)lwork);
            } else {
                logger.info("LAPACK DSYEVR error code: {}", (Object)info.val);
            }
            lwork = Math.max(1, lwork);
            liwork = Math.max(1, liwork);
            work = new double[lwork];
            iwork = new int[liwork];
            m.val = 0;
            info.val = 0;
            LAPACK.getInstance().dsyevr("N", "A", Lower, n, this.data(), this.ld(), 0.0, 0.0, 0, 0, abstol, m, d, V, 1, isuppz, work, lwork, iwork, liwork, info);
            if (info.val != 0) {
                logger.error("LAPACK DSYEVR error code: {}", (Object)info.val);
                throw new IllegalArgumentException("LAPACK DSYEVR error code: " + info.val);
            }
            double[] w = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                w[i] = d[n - i - 1];
            }
            return w;
        }
        double[] V = new double[]{};
        double[] d = new double[n];
        double[] e = new double[n];
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeev("N", "N", n, this.data(), this.ld(), d, e, V, 1, V, 1, work, -1, info);
        int lwork = 4 * n;
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.info("LAPACK DGEEV returns work space size: {}", (Object)lwork);
        } else {
            logger.info("LAPACK DGEEV error code: {}", (Object)info.val);
        }
        lwork = Math.max(1, lwork);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgeev("N", "N", n, this.data(), this.ld(), d, e, V, 1, V, 1, work, lwork, info);
        if (info.val != 0) {
            logger.error("LAPACK DGEEV error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGEEV error code: " + info.val);
        }
        NLMatrix.sort((double[])d, (double[])e);
        double[] w = new double[2 * n];
        System.arraycopy(d, 0, w, 0, n);
        System.arraycopy(e, 0, w, n, n);
        return w;
    }

    public EVD eigen() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Eigen decomposition on non-square matrix");
        }
        int n = this.nrows();
        if (this.isSymmetric()) {
            NLMatrix V = new NLMatrix(n, n);
            double[] d = new double[n];
            double abstol = LAPACK.getInstance().dlamch("Safe minimum");
            int[] isuppz = new int[2 * Math.max(1, n)];
            double[] work = new double[1];
            int[] iwork = new int[1];
            intW m = new intW(0);
            intW info = new intW(0);
            LAPACK.getInstance().dsyevr("V", "A", Lower, n, this.data(), this.ld(), 0.0, 0.0, 0, 0, abstol, m, d, V.data(), V.ld(), isuppz, work, -1, iwork, -1, info);
            int lwork = 26 * n;
            int liwork = 10 * n;
            if (info.val == 0) {
                lwork = (int)work[0];
                liwork = iwork[0];
                logger.info("LAPACK DSYEVR returns work space size: {}", (Object)lwork);
            } else {
                logger.info("LAPACK DSYEVR error code: {}", (Object)info.val);
            }
            lwork = Math.max(1, lwork);
            liwork = Math.max(1, liwork);
            work = new double[lwork];
            iwork = new int[liwork];
            m.val = 0;
            info.val = 0;
            LAPACK.getInstance().dsyevr("V", "A", Lower, n, this.data(), this.ld(), 0.0, 0.0, 0, 0, abstol, m, d, V.data(), V.ld(), isuppz, work, lwork, iwork, liwork, info);
            if (info.val != 0) {
                logger.error("LAPACK DSYEVR error code: {}", (Object)info.val);
                throw new IllegalArgumentException("LAPACK DSYEVR error code: " + info.val);
            }
            NLMatrix.reverse(d, (DenseMatrix)V);
            return new EVD((DenseMatrix)V, d);
        }
        NLMatrix V = new NLMatrix(n, n);
        double[] d = new double[n];
        double[] e = new double[n];
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeev("N", "V", n, this.data(), this.ld(), d, e, V.data(), 1, V.data(), V.ld(), work, -1, info);
        int lwork = 4 * n;
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.info("LAPACK DGEEV returns work space size: {}", (Object)lwork);
        } else {
            logger.info("LAPACK DGEEV error code: {}", (Object)info.val);
        }
        lwork = Math.max(1, lwork);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgeev("N", "V", n, this.data(), this.ld(), d, e, new double[0], 1, V.data(), V.ld(), work, lwork, info);
        if (info.val != 0) {
            logger.error("LAPACK DGEEV error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGEEV error code: " + info.val);
        }
        NLMatrix.sort((double[])d, (double[])e, (DenseMatrix)V);
        return new EVD((DenseMatrix)V, d, e);
    }

    static void reverse(double[] d, DenseMatrix V) {
        int m = V.nrows();
        int n = d.length;
        int half = n / 2;
        for (int i = 0; i < half; ++i) {
            double tmp = d[i];
            d[i] = d[n - i - 1];
            d[n - i - 1] = tmp;
        }
        for (int j = 0; j < half; ++j) {
            for (int i = 0; i < m; ++i) {
                double tmp = V.get(i, j);
                V.set(i, j, V.get(i, n - j - 1));
                V.set(i, n - j - 1, tmp);
            }
        }
    }
}

