/*
 * Decompiled with CFR 0.152.
 */
package smile.netlib;

import com.github.fommil.netlib.LAPACK;
import org.netlib.util.intW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.netlib.NLMatrix;

public class Cholesky
extends smile.math.matrix.Cholesky {
    private static final Logger logger = LoggerFactory.getLogger(Cholesky.class);

    public Cholesky(DenseMatrix L) {
        super(L);
    }

    public DenseMatrix inverse() {
        int n = this.L.nrows();
        DenseMatrix inv = Matrix.eye((int)n);
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b) {
        DenseMatrix B = Matrix.newInstance((double[])b);
        this.solve(B);
    }

    public void solve(DenseMatrix B) {
        if (B.nrows() != this.L.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.L.nrows(), this.L.ncols(), B.nrows(), B.ncols()));
        }
        intW info = new intW(0);
        LAPACK.getInstance().dpotrs(NLMatrix.Lower, this.L.nrows(), B.ncols(), this.L.data(), this.L.ld(), B.data(), B.ld(), info);
        if (info.val < 0) {
            logger.error("LAPACK DPOTRS error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DPOTRS error code: " + info.val);
        }
    }
}

