/*
 * Decompiled with CFR 0.152.
 */
package smile.netlib;

import com.github.fommil.netlib.LAPACK;
import org.netlib.util.intW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.netlib.NLMatrix;

class LU
extends smile.math.matrix.LU {
    private static final Logger logger = LoggerFactory.getLogger(LU.class);

    public LU(NLMatrix lu, int[] piv, boolean singular) {
        super((DenseMatrix)lu, piv, LU.pivsign(piv, Math.min(lu.nrows(), lu.ncols())), singular);
    }

    private static int pivsign(int[] piv, int n) {
        int pivsign = 1;
        for (int i = 0; i < n; ++i) {
            if (piv[i] == i + 1) continue;
            pivsign = -pivsign;
        }
        return pivsign;
    }

    public DenseMatrix inverse() {
        int n;
        int m = this.lu.nrows();
        if (m != (n = this.lu.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        int nb = LAPACK.getInstance().ilaenv(1, "DGETRI", "", n, -1, -1, -1);
        if (nb < 0) {
            logger.warn("LAPACK ILAENV error code: {}", (Object)nb);
        }
        if (nb < 1) {
            nb = 1;
        }
        int lwork = this.lu.ncols() * nb;
        double[] work = new double[lwork];
        intW info = new intW(0);
        LAPACK.getInstance().dgetri(this.lu.ncols(), this.lu.data(), this.lu.ld(), this.piv, work, lwork, info);
        if (info.val != 0) {
            logger.error("LAPACK DGETRI error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGETRI error code: " + info.val);
        }
        return this.lu;
    }

    public void solve(double[] b) {
        DenseMatrix B = Matrix.of((double[])b);
        this.solve(B);
    }

    public void solve(DenseMatrix B) {
        int m = this.lu.nrows();
        int n = this.lu.ncols();
        if (B.nrows() != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.lu.nrows(), this.lu.ncols(), B.nrows(), B.ncols()));
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgetrs(NLMatrix.Transpose, this.lu.nrows(), B.ncols(), this.lu.data(), this.lu.ld(), this.piv, B.data(), B.ld(), info);
        if (info.val < 0) {
            logger.error("LAPACK DGETRS error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DGETRS error code: " + info.val);
        }
    }
}

