/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.util.Arrays;
import java.util.HashMap;
import smile.nlp.AnchorText;
import smile.nlp.Text;
import smile.nlp.TextTerms;
import smile.util.MutableInt;
import smile.util.Strings;

public class SimpleText
extends Text
implements TextTerms,
AnchorText {
    private String anchor;
    private String[] words;
    private HashMap<String, MutableInt> freq = new HashMap();
    private int maxtf;

    public SimpleText(String id, String title, String body, String[] words) {
        super(id, title, body);
        this.words = words;
        for (String w : words) {
            MutableInt count = this.freq.get(w);
            if (count == null) {
                count = new MutableInt(1);
                this.freq.put(w, count);
            } else {
                count.increment();
            }
            if (count.value <= this.maxtf) continue;
            this.maxtf = count.value;
        }
    }

    @Override
    public int size() {
        return this.words.length;
    }

    @Override
    public Iterable<String> words() {
        return Arrays.asList(this.words);
    }

    @Override
    public Iterable<String> unique() {
        return this.freq.keySet();
    }

    @Override
    public int tf(String term) {
        MutableInt count = this.freq.get(term);
        return count == null ? 0 : count.value;
    }

    @Override
    public int maxtf() {
        return this.maxtf;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public SimpleText setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    @Override
    public SimpleText addAnchor(String linkLabel) {
        this.anchor = this.anchor == null ? linkLabel : this.anchor + "\n" + linkLabel;
        return this;
    }

    public String toString() {
        return String.format("Document[%s]", this.id, Strings.isNullOrEmpty((String)this.title) ? this.id : this.title);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleText other = (SimpleText)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

