/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.stemmer;

import smile.nlp.stemmer.Stemmer;

public class PorterStemmer
implements Stemmer {
    private char[] b;
    private int j;
    private int k;

    private final boolean isConsonant(int i) {
        switch (this.b[i]) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return false;
            }
            case 'y': {
                return i == 0 ? true : !this.isConsonant(i - 1);
            }
        }
        return true;
    }

    private final int m() {
        int n = 0;
        int i = 0;
        while (true) {
            if (i > this.j) {
                return n;
            }
            if (!this.isConsonant(i)) break;
            ++i;
        }
        ++i;
        while (i <= this.j) {
            if (!this.isConsonant(i)) {
                ++i;
                continue;
            }
            ++i;
            ++n;
            while (true) {
                if (i > this.j) {
                    return n;
                }
                if (!this.isConsonant(i)) break;
                ++i;
            }
            ++i;
        }
        return n;
    }

    private final boolean vowelinstem() {
        for (int i = 0; i <= this.j; ++i) {
            if (this.isConsonant(i)) continue;
            return true;
        }
        return false;
    }

    private final boolean doublec(int j) {
        if (j < 1) {
            return false;
        }
        if (this.b[j] != this.b[j - 1]) {
            return false;
        }
        return this.isConsonant(j);
    }

    private final boolean cvc(int i) {
        if (i < 2 || !this.isConsonant(i) || this.isConsonant(i - 1) || !this.isConsonant(i - 2)) {
            return false;
        }
        char ch = this.b[i];
        return ch != 'w' && ch != 'x' && ch != 'y';
    }

    private final boolean endsWith(String s) {
        int l = s.length();
        int o = this.k - l + 1;
        if (o < 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.b[o + i] == s.charAt(i)) continue;
            return false;
        }
        this.j = this.k - l;
        return true;
    }

    private final void setto(String s) {
        int l = s.length();
        int o = this.j + 1;
        for (int i = 0; i < l; ++i) {
            this.b[o + i] = s.charAt(i);
        }
        this.k = this.j + l;
    }

    private final void r(String s) {
        if (this.m() > 0) {
            this.setto(s);
        }
    }

    private final void step1() {
        this.step1(false);
    }

    private final void step1(boolean y) {
        if (this.b[this.k] == 's') {
            if (this.endsWith("sses")) {
                this.k -= 2;
            } else if (this.endsWith("ies")) {
                if (y && this.k - 3 >= 0 && this.isConsonant(this.k - 3)) {
                    this.setto("y");
                } else {
                    this.setto("i");
                }
            } else if (this.b[this.k - 1] != 's') {
                --this.k;
            }
        }
        if (this.endsWith("eed")) {
            if (this.m() > 0) {
                --this.k;
            }
        } else if ((this.endsWith("ed") || this.endsWith("ing")) && this.vowelinstem()) {
            this.k = this.j;
            if (this.endsWith("at")) {
                this.setto("ate");
            } else if (this.endsWith("bl")) {
                this.setto("ble");
            } else if (this.endsWith("iz")) {
                this.setto("ize");
            } else if (y && this.endsWith("i") && this.k - 1 >= 0 && this.isConsonant(this.k - 1)) {
                this.setto("y");
            } else if (this.doublec(this.k)) {
                --this.k;
                char ch = this.b[this.k];
                if (ch == 'l' || ch == 's' || ch == 'z') {
                    ++this.k;
                }
            } else if (this.m() == 1 && this.cvc(this.k)) {
                this.setto("e");
            }
        }
    }

    private final void step2() {
        if (this.endsWith("y") && this.vowelinstem()) {
            this.b[this.k] = 105;
        }
    }

    private final void step3() {
        if (this.k == 0) {
            return;
        }
        switch (this.b[this.k - 1]) {
            case 'a': {
                if (this.endsWith("ational")) {
                    this.r("ate");
                    break;
                }
                if (!this.endsWith("tional")) break;
                this.r("tion");
                break;
            }
            case 'c': {
                if (this.endsWith("enci")) {
                    this.r("ence");
                    break;
                }
                if (!this.endsWith("anci")) break;
                this.r("ance");
                break;
            }
            case 'e': {
                if (!this.endsWith("izer")) break;
                this.r("ize");
                break;
            }
            case 'l': {
                if (this.endsWith("bli")) {
                    this.r("ble");
                    break;
                }
                if (this.endsWith("alli")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("entli")) {
                    this.r("ent");
                    break;
                }
                if (this.endsWith("eli")) {
                    this.r("e");
                    break;
                }
                if (!this.endsWith("ousli")) break;
                this.r("ous");
                break;
            }
            case 'o': {
                if (this.endsWith("ization")) {
                    this.r("ize");
                    break;
                }
                if (this.endsWith("ation")) {
                    this.r("ate");
                    break;
                }
                if (!this.endsWith("ator")) break;
                this.r("ate");
                break;
            }
            case 's': {
                if (this.endsWith("alism")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("iveness")) {
                    this.r("ive");
                    break;
                }
                if (this.endsWith("fulness")) {
                    this.r("ful");
                    break;
                }
                if (!this.endsWith("ousness")) break;
                this.r("ous");
                break;
            }
            case 't': {
                if (this.endsWith("aliti")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("iviti")) {
                    this.r("ive");
                    break;
                }
                if (!this.endsWith("biliti")) break;
                this.r("ble");
                break;
            }
            case 'g': {
                if (!this.endsWith("logi")) break;
                this.r("log");
            }
        }
    }

    private final void step4() {
        switch (this.b[this.k]) {
            case 'e': {
                if (this.endsWith("icate")) {
                    this.r("ic");
                    break;
                }
                if (this.endsWith("ative")) {
                    this.r("");
                    break;
                }
                if (!this.endsWith("alize")) break;
                this.r("al");
                break;
            }
            case 'i': {
                if (!this.endsWith("iciti")) break;
                this.r("ic");
                break;
            }
            case 'l': {
                if (this.endsWith("ical")) {
                    this.r("ic");
                    break;
                }
                if (!this.endsWith("ful")) break;
                this.r("");
                break;
            }
            case 's': {
                if (!this.endsWith("ness")) break;
                this.r("");
            }
        }
    }

    private final void step5() {
        if (this.k == 0) {
            return;
        }
        switch (this.b[this.k - 1]) {
            case 'a': {
                if (this.endsWith("al")) break;
                return;
            }
            case 'c': {
                if (this.endsWith("ance") || this.endsWith("ence")) break;
                return;
            }
            case 'e': {
                if (this.endsWith("er")) break;
                return;
            }
            case 'i': {
                if (this.endsWith("ic")) break;
                return;
            }
            case 'l': {
                if (this.endsWith("able") || this.endsWith("ible")) break;
                return;
            }
            case 'n': {
                if (this.endsWith("ant") || this.endsWith("ement") || this.endsWith("ment") || this.endsWith("ent")) break;
                return;
            }
            case 'o': {
                if (this.endsWith("ion") && this.j >= 0 && (this.b[this.j] == 's' || this.b[this.j] == 't') || this.endsWith("ou")) break;
                return;
            }
            case 's': {
                if (this.endsWith("ism")) break;
                return;
            }
            case 't': {
                if (this.endsWith("ate") || this.endsWith("iti")) break;
                return;
            }
            case 'u': {
                if (this.endsWith("ous")) break;
                return;
            }
            case 'v': {
                if (this.endsWith("ive")) break;
                return;
            }
            case 'z': {
                if (this.endsWith("ize")) break;
                return;
            }
            default: {
                return;
            }
        }
        if (this.m() > 1) {
            this.k = this.j;
        }
    }

    private final void step6() {
        int a;
        this.j = this.k;
        if (this.b[this.k] == 'e' && ((a = this.m()) > 1 || a == 1 && !this.cvc(this.k - 1))) {
            --this.k;
        }
        if (this.b[this.k] == 'l' && this.doublec(this.k) && this.m() > 1) {
            --this.k;
        }
    }

    @Override
    public String stem(String word) {
        this.b = word.toCharArray();
        this.k = word.length() - 1;
        if (this.k > 1) {
            this.step1();
            this.step2();
            this.step3();
            this.step4();
            this.step5();
            this.step6();
        }
        return new String(this.b, 0, this.k + 1);
    }

    public String stripPluralParticiple(String word) {
        this.b = word.toCharArray();
        this.k = word.length() - 1;
        if (!(this.k <= 1 || word.equalsIgnoreCase("is") || word.equalsIgnoreCase("was") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("his") || word.equalsIgnoreCase("this"))) {
            this.step1(true);
            return new String(this.b, 0, this.k + 1);
        }
        return word;
    }
}

