/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

interface EnglishAbbreviations {
    public static final Set<String> dictionary = EnglishAbbreviations.dictionary();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> dictionary() {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(EnglishAbbreviations.class.getResourceAsStream("/smile/nlp/tokenizer/abbreviations_en.txt")));){
            Set<String> set = input.lines().map(line -> line.trim()).filter(line -> !line.isEmpty()).collect(Collectors.toSet());
            return set;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Collections.emptySet();
        }
    }

    public static boolean contains(String s) {
        return dictionary.contains(s);
    }

    public static int size() {
        return dictionary.size();
    }

    public static Iterator<String> iterator() {
        return dictionary.iterator();
    }
}

