/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.util.HashMap;
import java.util.LinkedList;

public class Trie<K, V> {
    private final HashMap<K, Node> root;
    private int size;

    public Trie() {
        this.root = new HashMap();
    }

    public Trie(int initialCapacity) {
        this.root = new HashMap(initialCapacity);
    }

    public void put(K[] key, V value) {
        Node child = this.root.get(key[0]);
        if (child == null) {
            child = new Node(key[0]);
            this.root.put(key[0], child);
        }
        child.addChild(key, value, 1);
    }

    public V get(K[] key) {
        Node child = this.root.get(key[0]);
        if (child != null) {
            return child.getChild(key, 1);
        }
        return null;
    }

    public Node get(K key) {
        return this.root.get(key);
    }

    public int size() {
        return this.size;
    }

    public class Node {
        private final K key;
        private V value;
        private final LinkedList<Node> children;

        public Node(K key) {
            this.key = key;
            this.value = null;
            this.children = new LinkedList();
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V getChild(K[] key, int index) {
            if (index >= key.length) {
                return this.value;
            }
            Object k = key[index];
            for (Node child : this.children) {
                if (!child.key.equals(k)) continue;
                return child.getChild(key, index + 1);
            }
            return null;
        }

        public Node getChild(K key) {
            for (Node child : this.children) {
                if (!child.key.equals(key)) continue;
                return child;
            }
            return null;
        }

        public void addChild(K[] key, V value, int index) {
            if (index >= key.length) {
                if (this.value == null) {
                    Trie.this.size++;
                }
                this.value = value;
                return;
            }
            for (Node child : this.children) {
                if (!child.key.equals(key[index])) continue;
                child.addChild(key, value, index + 1);
                return;
            }
            Node child = new Node(key[index]);
            this.children.addFirst(child);
            child.addChild(key, value, index + 1);
        }
    }
}

