/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.dictionary;

import java.util.HashSet;
import java.util.Iterator;
import smile.nlp.dictionary.Punctuations;

public class EnglishPunctuations
implements Punctuations {
    private static final EnglishPunctuations singleton = new EnglishPunctuations();
    private final HashSet<String> dict = new HashSet(50);

    private EnglishPunctuations() {
        this.dict.add("[");
        this.dict.add("]");
        this.dict.add("(");
        this.dict.add(")");
        this.dict.add("{");
        this.dict.add("}");
        this.dict.add("<");
        this.dict.add(">");
        this.dict.add(":");
        this.dict.add(",");
        this.dict.add(";");
        this.dict.add("-");
        this.dict.add("--");
        this.dict.add("---");
        this.dict.add("!");
        this.dict.add("?");
        this.dict.add(".");
        this.dict.add("...");
        this.dict.add("`");
        this.dict.add("'");
        this.dict.add("\"");
        this.dict.add("/");
    }

    public static EnglishPunctuations getInstance() {
        return singleton;
    }

    @Override
    public boolean contains(String word) {
        return this.dict.contains(word);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.dict.iterator();
    }
}

