/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.stemmer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.nlp.stemmer.Stemmer;

public class LancasterStemmer
implements Stemmer {
    private static final Logger logger = LoggerFactory.getLogger(LancasterStemmer.class);
    private final ArrayList<String> rules = new ArrayList();
    private final int[] index = new int[26];
    private final boolean stripPrefix;

    private void readRules(InputStream is) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(is));){
            input.lines().map(String::trim).filter(line -> !line.isEmpty()).forEach(rule -> {
                int j = rule.indexOf(32);
                if (j != -1) {
                    rule = rule.substring(0, j);
                }
                this.rules.add((String)rule);
            });
        }
        char ch = 'a';
        for (int j = 0; j < this.rules.size(); ++j) {
            while (this.rules.get(j).charAt(0) != ch) {
                ch = (char)(ch + '\u0001');
                this.index[LancasterStemmer.charCode((char)ch)] = j;
            }
        }
    }

    public LancasterStemmer() {
        this(false);
    }

    public LancasterStemmer(boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
        try {
            this.readRules(LancasterStemmer.class.getResourceAsStream("/smile/nlp/stemmer/Lancaster_rules.txt"));
        }
        catch (IOException ex) {
            logger.error("Failed to load /smile/nlp/stemmer/Lancaster_rules.txt", (Throwable)ex);
        }
    }

    public LancasterStemmer(InputStream customizedRules) throws IOException {
        this(customizedRules, false);
    }

    public LancasterStemmer(InputStream customizedRules, boolean stripPrefix) throws IOException {
        this.stripPrefix = stripPrefix;
        this.readRules(customizedRules);
    }

    private int firstVowel(String word, int last) {
        int i = 0;
        if (i < last && !this.vowel(word.charAt(i), 'a')) {
            ++i;
        }
        if (i != 0) {
            while (i < last && !this.vowel(word.charAt(i), word.charAt(i - 1))) {
                ++i;
            }
        }
        return Math.min(i, last);
    }

    private String stripSuffixes(String word) {
        int Continue = 0;
        int pll = 0;
        boolean intact = true;
        String stem = this.cleanup(word.toLowerCase());
        while (pll + 1 < stem.length() && stem.charAt(pll + 1) >= 'a' && stem.charAt(pll + 1) <= 'z') {
            ++pll;
        }
        if (pll < 1) {
            Continue = -1;
        }
        int pfv = this.firstVowel(stem, pll);
        int iw = stem.length() - 1;
        while (Continue != -1) {
            Continue = 0;
            char ll = stem.charAt(pll);
            int prt = ll >= 'a' && ll <= 'z' ? this.index[LancasterStemmer.charCode(ll)] : -1;
            if (prt == -1) {
                Continue = -1;
            }
            if (Continue != 0) continue;
            String rule = this.rules.get(prt);
            while (Continue == 0) {
                int ruleok = 0;
                if (rule.charAt(0) != ll) {
                    Continue = -1;
                    ruleok = -1;
                }
                int ir = 1;
                iw = pll - 1;
                while (ruleok == 0) {
                    if (rule.charAt(ir) >= '0' && rule.charAt(ir) <= '9') {
                        ruleok = 1;
                        continue;
                    }
                    if (rule.charAt(ir) == '*') {
                        if (intact) {
                            ++ir;
                            ruleok = 1;
                            continue;
                        }
                        ruleok = -1;
                        continue;
                    }
                    if (rule.charAt(ir) != stem.charAt(iw)) {
                        ruleok = -1;
                        continue;
                    }
                    if (iw <= pfv) {
                        ruleok = -1;
                        continue;
                    }
                    ++ir;
                    --iw;
                }
                if (ruleok == 1) {
                    int xl = 0;
                    while (rule.charAt(ir + xl + 1) < '.' || rule.charAt(ir + xl + 1) > '>') {
                        ++xl;
                    }
                    xl = pll + xl + 48 - rule.charAt(ir);
                    if (pfv == 0) {
                        if (xl < 1) {
                            ruleok = -1;
                        }
                    } else if (xl < 2 | xl < pfv) {
                        ruleok = -1;
                    }
                }
                if (ruleok == 1) {
                    intact = false;
                    pll = pll + 48 - rule.charAt(ir);
                    ++ir;
                    StringBuilder sb = new StringBuilder(stem.substring(0, pll + 1));
                    while (ir < rule.length() && 'a' <= rule.charAt(ir) && rule.charAt(ir) <= 'z') {
                        sb.append(rule.charAt(ir));
                        ++ir;
                        ++pll;
                    }
                    stem = sb.toString();
                    if (rule.charAt(ir) == '.') {
                        Continue = -1;
                        continue;
                    }
                    Continue = 1;
                    continue;
                }
                if (++prt >= this.rules.size()) {
                    Continue = -1;
                    continue;
                }
                rule = this.rules.get(prt);
                if (rule.charAt(0) == ll) continue;
                Continue = -1;
            }
        }
        return stem;
    }

    private boolean vowel(char ch, char prev) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
            case 'y': {
                switch (prev) {
                    case 'a': 
                    case 'e': 
                    case 'i': 
                    case 'o': 
                    case 'u': {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static int charCode(char ch) {
        return ch - 97;
    }

    private String stripPrefixes(String word) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{"kilo", "micro", "milli", "intra", "ultra", "mega", "nano", "pico", "pseudo"}) {
            if (!word.startsWith(prefix) || word.length() <= prefix.length()) continue;
            word = word.substring(prefix.length());
            return word;
        }
        return word;
    }

    private String cleanup(String word) {
        int last = word.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < last; ++i) {
            if (!(word.charAt(i) >= 'a' & word.charAt(i) <= 'z')) continue;
            sb.append(word.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String stem(String word) {
        if ((word = this.cleanup(word.toLowerCase())).length() > 3 && this.stripPrefix) {
            word = this.stripPrefixes(word);
        }
        if (word.length() > 3) {
            word = this.stripSuffixes(word);
        }
        return word;
    }
}

