/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import smile.nlp.dictionary.Dictionary;

public enum EnglishDictionary implements Dictionary
{
    CONCISE("/smile/nlp/dictionary/dictionary_en.txt");

    private final HashSet<String> dict = new HashSet();

    private EnglishDictionary(String resource) {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource)));){
            String line;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.matches("^[A-Z]$")) continue;
                this.dict.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean contains(String s) {
        return this.dict.contains(s);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.dict.iterator();
    }
}

