/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import smile.nlp.dictionary.StopWords;

public enum EnglishStopWords implements StopWords
{
    DEFAULT("/smile/nlp/dictionary/stop-words_en.txt"),
    COMPREHENSIVE("/smile/nlp/dictionary/stop-words_en_more.txt"),
    GOOGLE("/smile/nlp/dictionary/stop-words_en_google.txt"),
    MYSQL("/smile/nlp/dictionary/stop-words_en_mysql.txt");

    private final HashSet<String> dict = new HashSet();

    private EnglishStopWords(String resource) {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource)));){
            String line;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                this.dict.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean contains(String word) {
        return this.dict.contains(word);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.dict.iterator();
    }
}

