/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.pos;

import java.util.regex.Pattern;
import smile.nlp.pos.PennTreebankPOS;
import smile.util.Regex;

class RegexPOSTagger {
    private static final Pattern[] REGEX = new Pattern[]{Regex.CARDINAL_NUMBER, Regex.CARDINAL_NUMBER_WITH_COMMA, Regex.PHONE_NUMBER, Regex.PHONE_NUMBER_EXTENSION, Regex.URL, Regex.EMAIL_ADDRESS};
    private static final PennTreebankPOS[] REGEX_POS = new PennTreebankPOS[]{PennTreebankPOS.CD, PennTreebankPOS.CD, PennTreebankPOS.NN, PennTreebankPOS.NN, PennTreebankPOS.NN, PennTreebankPOS.NN};

    private RegexPOSTagger() {
    }

    public static PennTreebankPOS tag(String word) {
        for (int i = 0; i < REGEX.length; ++i) {
            if (!REGEX[i].matcher(word).matches()) continue;
            return REGEX_POS[i];
        }
        return null;
    }
}

