/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.relevance;

import smile.nlp.Corpus;
import smile.nlp.TextTerms;
import smile.nlp.relevance.RelevanceRanker;

public class BM25
implements RelevanceRanker {
    private final double k1;
    private final double b;
    private final double delta;

    public BM25() {
        this(1.2, 0.75, 1.0);
    }

    public BM25(double k1, double b, double delta) {
        if (k1 < 0.0) {
            throw new IllegalArgumentException("Negative k1 = " + k1);
        }
        if (b < 0.0 || b > 1.0) {
            throw new IllegalArgumentException("Invalid b = " + b);
        }
        if (delta < 0.0) {
            throw new IllegalArgumentException("Invalid delta = " + delta);
        }
        this.k1 = k1;
        this.b = b;
        this.delta = delta;
    }

    public double score(int termFreq, int docSize, double avgDocSize, int titleTermFreq, int titleSize, double avgTitleSize, int anchorTermFreq, int anchorSize, double avgAnchorSize, long N, long n) {
        if (termFreq <= 0) {
            return 0.0;
        }
        double kf = 4.9;
        double bTitle = 0.6;
        double bBody = 0.5;
        double bAnchor = 0.6;
        double wTitle = 13.5;
        double wBody = 1.0;
        double wAnchor = 11.5;
        double tf = 1.0 * (double)termFreq / (1.0 + 0.5 * ((double)docSize / avgDocSize - 1.0));
        if (titleTermFreq > 0) {
            tf += 13.5 * (double)titleTermFreq / (1.0 + 0.6 * ((double)titleSize / avgTitleSize - 1.0));
        }
        if (anchorTermFreq > 0) {
            tf += 11.5 * (double)anchorTermFreq / (1.0 + 0.6 * ((double)anchorSize / avgAnchorSize - 1.0));
        }
        tf /= 4.9 + tf;
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5) + 1.0);
        return (tf + this.delta) * idf;
    }

    public double score(double freq, long N, long n) {
        if (freq <= 0.0) {
            return 0.0;
        }
        double tf = (this.k1 + 1.0) * freq / (freq + this.k1);
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5) + 1.0);
        return (tf + this.delta) * idf;
    }

    public double score(double freq, int docSize, double avgDocSize, long N, long n) {
        if (freq <= 0.0) {
            return 0.0;
        }
        double tf = freq * (this.k1 + 1.0) / (freq + this.k1 * (1.0 - this.b + this.b * (double)docSize / avgDocSize));
        double idf = Math.log(((double)(N - n) + 0.5) / ((double)n + 0.5) + 1.0);
        return (tf + this.delta) * idf;
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String term, int tf, int n) {
        if (tf <= 0) {
            return 0.0;
        }
        int N = corpus.ndoc();
        int docSize = doc.size();
        int avgDocSize = corpus.avgDocSize();
        return this.score(tf, docSize, avgDocSize, N, n);
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String[] terms, int[] tf, int n) {
        int N = corpus.ndoc();
        int docSize = doc.size();
        int avgDocSize = corpus.avgDocSize();
        double r = 0.0;
        for (int i = 0; i < terms.length; ++i) {
            r += this.score(tf[i], docSize, avgDocSize, N, n);
        }
        return r;
    }
}

