/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.collocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import smile.nlp.dictionary.EnglishPunctuations;
import smile.nlp.dictionary.EnglishStopWords;
import smile.util.MutableInt;

public class NGram
extends smile.nlp.NGram
implements Comparable<NGram> {
    public final int count;

    public NGram(String[] words, int count) {
        super(words);
        this.count = count;
    }

    @Override
    public String toString() {
        return String.format("(%s, %d)", super.toString(), this.count);
    }

    @Override
    public int compareTo(NGram o) {
        return Integer.compare(this.count, o.count);
    }

    public static NGram[][] of(Collection<String[]> sentences, int maxNGramSize, int minFrequency) {
        ArrayList features = new ArrayList(maxNGramSize + 1);
        HashSet<NGram> feature = new HashSet<NGram>();
        features.add(feature);
        EnglishPunctuations punctuations = EnglishPunctuations.getInstance();
        for (int n = 1; n <= maxNGramSize; ++n) {
            smile.nlp.NGram ngram;
            HashMap<smile.nlp.NGram, MutableInt> candidates = new HashMap<smile.nlp.NGram, MutableInt>();
            for (String[] stringArray : sentences) {
                for (int i = 0; i <= stringArray.length - n; ++i) {
                    ngram = new smile.nlp.NGram(Arrays.copyOfRange(stringArray, i, i + n));
                    boolean add = false;
                    if (n == 1) {
                        add = true;
                    } else {
                        NGram initialGram = new NGram(Arrays.copyOfRange(stringArray, i, i + n - 1), 0);
                        NGram finalGram = new NGram(Arrays.copyOfRange(stringArray, i + 1, i + n), 0);
                        if (feature.contains(initialGram) && feature.contains(finalGram)) {
                            add = true;
                        }
                    }
                    if (!add) continue;
                    MutableInt count = (MutableInt)candidates.get(ngram);
                    if (count == null) {
                        candidates.put(ngram, new MutableInt(1));
                        continue;
                    }
                    count.increment();
                }
            }
            feature = new HashSet();
            features.add(feature);
            for (Map.Entry entry : candidates.entrySet()) {
                MutableInt count = (MutableInt)entry.getValue();
                if (count.value < minFrequency) continue;
                ngram = (smile.nlp.NGram)entry.getKey();
                if (ngram.words.length == 1 && punctuations.contains(ngram.words[0])) continue;
                feature.add(new NGram(ngram.words, count.value));
            }
        }
        EnglishStopWords stopWords = EnglishStopWords.DEFAULT;
        return (NGram[][])features.stream().map(ngrams -> {
            NGram[] collocations = (NGram[])ngrams.stream().filter(ngram -> {
                boolean stopWord = true;
                String[] words = ngram.words;
                if (!stopWords.contains(words[0]) && !stopWords.contains(words[words.length - 1])) {
                    for (String word : words) {
                        if (stopWords.contains(word)) continue;
                        stopWord = false;
                        break;
                    }
                }
                return !stopWord;
            }).toArray(NGram[]::new);
            Arrays.sort(collocations, Collections.reverseOrder());
            return collocations;
        }).toArray(x$0 -> new NGram[x$0][]);
    }
}

