/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.embedding;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.IntStream;
import smile.data.DataFrame;
import smile.data.vector.FloatVector;
import smile.data.vector.ValueVector;

public class Word2Vec {
    public final String[] words;
    public final DataFrame vectors;
    private final HashMap<String, Integer> map;

    public Word2Vec(String[] words, float[][] vectors) {
        this.words = words;
        this.vectors = new DataFrame((ValueVector[])IntStream.range(0, vectors.length).mapToObj(i -> new FloatVector("V" + (i + 1), vectors[i])).toArray(FloatVector[]::new));
        int n = words.length;
        this.map = new HashMap(n * 4 / 3 + 3);
        for (int i2 = 0; i2 < n; ++i2) {
            this.map.put(words[i2], i2);
        }
    }

    public int dimension() {
        return this.vectors.ncol();
    }

    public float[] get(String word) {
        Integer index = this.map.get(word);
        if (index == null) {
            return null;
        }
        int i = index;
        int dim = this.vectors.ncol();
        float[] vector = new float[dim];
        for (int j = 0; j < dim; ++j) {
            vector[j] = this.vectors.getFloat(i, j);
        }
        return vector;
    }

    public float[] apply(String word) {
        return this.get(word);
    }

    public static Word2Vec of(Path file) throws IOException {
        return Word2Vec.of(file, ByteOrder.LITTLE_ENDIAN);
    }

    public static Word2Vec of(Path file, ByteOrder order) throws IOException {
        long GB = 0x40000000L;
        try (FileInputStream input = new FileInputStream(file.toFile());){
            FileChannel channel = input.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(channel.size(), Integer.MAX_VALUE));
            buffer.order(order);
            int blocks = 1;
            StringBuilder sb = new StringBuilder();
            char c = (char)buffer.get();
            while (c != '\n') {
                sb.append(c);
                c = (char)buffer.get();
            }
            String line = sb.toString();
            String[] tokens = line.split("\\s+");
            if (tokens.length != 2) {
                throw new IllegalStateException("Invalid first line: " + line);
            }
            int size = Integer.parseInt(tokens[0]);
            int dim = Integer.parseInt(tokens[1]);
            String[] words = new String[size];
            float[][] vectors = new float[dim][size];
            for (int i = 0; i < size; ++i) {
                sb.setLength(0);
                c = (char)buffer.get();
                while (c != ' ') {
                    if (c != '\n') {
                        sb.append(c);
                    }
                    c = (char)buffer.get();
                }
                words[i] = sb.toString();
                FloatBuffer floatBuffer = buffer.asFloatBuffer();
                for (int j = 0; j < dim; ++j) {
                    vectors[j][i] = floatBuffer.get();
                }
                buffer.position(buffer.position() + 4 * dim);
                if ((long)buffer.position() <= 0x40000000L) continue;
                int newPosition = (int)((long)buffer.position() - 0x40000000L);
                long chunk = Math.min(channel.size() - 0x40000000L * (long)blocks, Integer.MAX_VALUE);
                buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0x40000000L * (long)blocks, chunk);
                buffer.order(order);
                buffer.position(newPosition);
                ++blocks;
            }
            Word2Vec word2Vec = new Word2Vec(words, vectors);
            return word2Vec;
        }
    }
}

