/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface EnglishAbbreviations {
    public static final Set<String> dictionary = EnglishAbbreviations.dictionary();

    public static Set<String> dictionary() {
        Set<String> set;
        BufferedReader input = new BufferedReader(new InputStreamReader(Objects.requireNonNull(EnglishAbbreviations.class.getResourceAsStream("/smile/nlp/tokenizer/abbreviations_en.txt"))));
        try {
            set = input.lines().map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toSet());
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger logger = LoggerFactory.getLogger(EnglishAbbreviations.class);
                logger.error("Failed to load English abbreviations", (Throwable)ex);
                return Collections.emptySet();
            }
        }
        input.close();
        return set;
    }

    public static boolean contains(String s) {
        return dictionary.contains(s);
    }

    public static int size() {
        return dictionary.size();
    }

    public static Iterator<String> iterator() {
        return dictionary.iterator();
    }
}

