/*
 * Copyright (c) 2010-2025 Haifeng Li. All rights reserved.
 *
 * Smile is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Smile is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Smile. If not, see <https://www.gnu.org/licenses/>.
 */
package smile.nlp.dictionary;

/**
 * Punctuation marks are symbols that indicate the structure and organization
 * of written language, as well as intonation and pauses to be observed when
 * reading aloud. In many languages, punctuation is vital to disambiguate the
 * meaning of sentences.
 * <p>
 * The rules of punctuation vary with language, location, register and time
 * and are constantly evolving. Certain aspects of punctuation are stylistic
 * and are thus the author's (or editor's) choice. Tachygraphic language forms,
 * such as those used in online chat and text messages, may have wildly
 * different rules.
 *
 * @author Haifeng Li
 */
public interface Punctuations extends Dictionary {

}
