/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.nlp.dictionary.Dictionary;

public class SimpleDictionary
implements Dictionary {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDictionary.class);
    private final HashSet<String> dict = new HashSet();

    public SimpleDictionary(String resource) {
        File file = new File(resource);
        try (BufferedReader input = file.exists() ? new BufferedReader(new FileReader(resource)) : new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(resource))));){
            String line;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.matches("^[A-Z]$")) continue;
                this.dict.add(line);
            }
        }
        catch (IOException ex) {
            logger.error("Failed to parse dictionary: ", (Throwable)ex);
        }
    }

    @Override
    public boolean contains(String word) {
        return this.dict.contains(word);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.dict.iterator();
    }
}

