/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.pos;

import java.util.HashMap;
import java.util.Map;

public enum PennTreebankPOS {
    CC(false),
    CD(true),
    DT(false),
    EX(false),
    FW(true),
    IN(false),
    JJ(true),
    JJR(true),
    JJS(true),
    LS(true),
    MD(false),
    NN(true),
    NNS(true),
    NNP(true),
    NNPS(true),
    PDT(false),
    POS(false),
    PRP(false),
    PRP$(false),
    RB(true),
    RBR(true),
    RBS(true),
    RP(false),
    SYM(true),
    TO(false),
    UH(true),
    VB(true),
    VBD(true),
    VBG(true),
    VBN(true),
    VBP(true),
    VBZ(true),
    WDT(false),
    WP(false),
    WP$(false),
    WRB(false),
    $(false),
    SENT(false){

        public String toString() {
            return ".";
        }
    }
    ,
    POUND(false){

        public String toString() {
            return "#";
        }
    }
    ,
    DASH(false){

        public String toString() {
            return "-";
        }
    }
    ,
    COMMA(false){

        public String toString() {
            return ",";
        }
    }
    ,
    COLON(false){

        public String toString() {
            return ":";
        }
    }
    ,
    OPENING_PARENTHESIS(false){

        public String toString() {
            return "(";
        }
    }
    ,
    CLOSING_PARENTHESIS(false){

        public String toString() {
            return ")";
        }
    }
    ,
    OPENING_QUOTATION(false){

        public String toString() {
            return "``";
        }
    }
    ,
    CLOSING_QUOTATION(false){

        public String toString() {
            return "''";
        }
    };

    public final boolean open;
    private static final Map<String, String> map;

    private PennTreebankPOS(boolean open) {
        this.open = open;
    }

    public static PennTreebankPOS getValue(String value) {
        String s = map.get(value);
        return PennTreebankPOS.valueOf(s == null ? value : s);
    }

    static {
        map = new HashMap<String, String>();
        map.put(".", "SENT");
        map.put("?", "SENT");
        map.put("!", "SENT");
        map.put("#", "POUND");
        map.put("-", "DASH");
        map.put(",", "COMMA");
        map.put(";", "COLON");
        map.put(":", "COLON");
        map.put("...", "COLON");
        map.put("(", "OPENING_PARENTHESIS");
        map.put("[", "OPENING_PARENTHESIS");
        map.put("{", "OPENING_PARENTHESIS");
        map.put(")", "CLOSING_PARENTHESIS");
        map.put("]", "CLOSING_PARENTHESIS");
        map.put("}", "CLOSING_PARENTHESIS");
        map.put("`", "OPENING_QUOTATION");
        map.put("``", "OPENING_QUOTATION");
        map.put("'", "CLOSING_QUOTATION");
        map.put("''", "CLOSING_QUOTATION");
    }
}

