/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashMap;
import smile.math.Math;
import smile.plot.Base;
import smile.plot.BaseLabel;
import smile.plot.Graphics;
import smile.plot.Label;
import smile.plot.Line;
import smile.sort.QuickSort;

public class Axis {
    private static final Font axisLabelFont = new Font("Arial", 1, 14);
    private static final Font gridLabelFont = new Font("BitStream Vera Sans", 0, 12);
    private Base base;
    private int index;
    private HashMap<String, Double> labels;
    private boolean labelVisible = true;
    private boolean gridVisible = true;
    private boolean frameVisible = true;
    private int linearSlices = 10;
    private double[] linesSlicing;
    private double[] labelsSlicing;
    private double[] origin;
    private BaseLabel axisLabel;
    private Line[][] gridLines;
    private Label[] gridLabels;
    private String[] gridLabelStrings;
    private double rotation = 0.0;

    public Axis(Base base, int index) {
        this(base, index, null);
    }

    public Axis(Base base, int index, String label) {
        this.base = base;
        this.index = index;
        this.setAxisLabel(label);
        this.init();
    }

    private void init() {
        this.initOrigin();
        this.setSlice();
        this.initGridLines();
        this.initGridLabels();
    }

    private void initOrigin() {
        this.origin = this.base.getCoordinateSpace()[0];
    }

    private void setSlice() {
        if (this.labels == null) {
            double min = this.base.getPrecisionUnit()[this.index] * Math.ceil((double)(this.base.getLowerBounds()[this.index] / this.base.getPrecisionUnit()[this.index]));
            double max = this.base.getPrecisionUnit()[this.index] * Math.floor((double)(this.base.getUpperBounds()[this.index] / this.base.getPrecisionUnit()[this.index]));
            this.linearSlices = (int)Math.ceil((double)Math.round((double)((max - min) / this.base.getPrecisionUnit()[this.index]), (int)1));
            if (this.linearSlices <= 0) {
                this.linearSlices = 1;
            }
            if (this.linearSlices < 3) {
                this.linearSlices *= 2;
            }
            this.linesSlicing = new double[this.linearSlices + 3];
            this.labelsSlicing = new double[this.linearSlices + 3];
            double pitch = (max - min) / (double)this.linearSlices;
            for (int i = 1; i <= this.linearSlices + 1; ++i) {
                this.linesSlicing[i] = min + (double)(i - 1) * pitch;
                this.labelsSlicing[i] = min + (double)(i - 1) * pitch;
            }
            this.linesSlicing[0] = this.base.getLowerBounds()[this.index];
            this.labelsSlicing[0] = this.base.getLowerBounds()[this.index];
            this.linesSlicing[this.linearSlices + 2] = this.base.getUpperBounds()[this.index];
            this.labelsSlicing[this.linearSlices + 2] = this.base.getUpperBounds()[this.index];
        } else {
            this.linesSlicing = new double[this.labels.size() + 2];
            this.labelsSlicing = new double[this.labels.size()];
            this.gridLabelStrings = new String[this.labels.size()];
            this.linesSlicing[0] = this.base.getLowerBounds()[this.index];
            int i = 1;
            for (String string : this.labels.keySet()) {
                this.linesSlicing[i] = this.labels.get(string);
                this.labelsSlicing[i - 1] = this.labels.get(string);
                this.gridLabelStrings[i - 1] = string;
                ++i;
            }
            this.linesSlicing[i] = this.base.getUpperBounds()[this.index];
            Arrays.sort(this.linesSlicing);
            QuickSort.sort((double[])this.labelsSlicing, (Object[])this.gridLabelStrings);
        }
    }

    private void initGridLabels() {
        int dim = this.base.getDimension();
        double[] offset = new double[dim];
        for (int j = 0; j < dim; ++j) {
            if (j == this.index) continue;
            offset[j] = -(this.base.getUpperBounds()[j] - this.base.getLowerBounds()[j]) / 100.0;
        }
        int decimal = 0;
        this.gridLabels = new Label[this.labelsSlicing.length];
        for (int i = 0; i < this.gridLabels.length; ++i) {
            String label;
            double[] labelCoord = new double[this.base.getDimension()];
            System.arraycopy(this.base.getCoordinateSpace()[this.index + 1], 0, labelCoord, 0, this.base.getDimension());
            labelCoord[this.index] = this.labelsSlicing[i];
            if (dim == 3) {
                if (this.index == 0) {
                    labelCoord[2] = this.base.getUpperBounds()[2] - 2.0 * offset[2];
                } else if (this.index == 1) {
                    labelCoord[0] = this.base.getUpperBounds()[0] - 2.0 * offset[0];
                } else if (this.index == 2) {
                    labelCoord[1] = this.base.getUpperBounds()[1] - 2.0 * offset[1];
                }
            }
            decimal = this.base.getPrecisionDigits()[this.index];
            if (this.gridLabelStrings != null) {
                label = this.gridLabelStrings[i % this.gridLabelStrings.length];
            } else {
                String format = "%.0f";
                if (decimal < 0) {
                    format = String.format("%%.%df", -decimal);
                }
                label = String.format(format, this.labelsSlicing[i]);
            }
            for (int j = 0; j < dim; ++j) {
                int n = j;
                labelCoord[n] = labelCoord[n] + offset[j];
            }
            if (this.base.getDimension() == 2) {
                this.gridLabels[i] = this.index == 0 ? (this.rotation == 0.0 ? new Label(label, 0.5, 1.0, labelCoord) : new Label(label, 1.0, 0.5, this.rotation, labelCoord)) : new Label(label, 1.0, 0.5, labelCoord);
            } else if (this.index == 0) {
                this.gridLabels[i] = new Label(label, 0.5, -0.5, labelCoord);
            } else if (this.index == 1) {
                this.gridLabels[i] = new Label(label, 0.5, 1.0, labelCoord);
            } else if (this.index == 2) {
                this.gridLabels[i] = new Label(label, 0.0, 0.5, labelCoord);
            }
            this.gridLabels[i].setFont(gridLabelFont);
        }
        this.gridLabelStrings = null;
    }

    private void initGridLines() {
        this.gridLines = new Line[this.base.getDimension() - 1][this.linesSlicing.length];
        int i2 = 0;
        for (int i = 0; i < this.base.getDimension() - 1; ++i) {
            if (i2 == this.index) {
                ++i2;
            }
            for (int j = 0; j < this.gridLines[i].length; ++j) {
                double[] originBase = new double[this.base.getDimension()];
                double[] endBase = new double[this.base.getDimension()];
                System.arraycopy(this.origin, 0, originBase, 0, this.base.getDimension());
                System.arraycopy(this.origin, 0, endBase, 0, this.base.getDimension());
                endBase[i2] = this.base.getCoordinateSpace()[i2 + 1][i2];
                originBase[this.index] = this.linesSlicing[j];
                endBase[this.index] = this.linesSlicing[j];
                this.gridLines[i][j] = j == 0 || j == this.gridLines[i].length - 1 ? new Line(originBase, endBase) : new Line(Line.Style.DOT, Color.lightGray, (double[][])new double[][]{originBase, endBase});
            }
            ++i2;
        }
    }

    public Axis setBase(Base base) {
        this.base = base;
        if (this.getAxisLabel() != null) {
            this.setAxisLabel(this.getAxisLabel());
        }
        this.init();
        return this;
    }

    public Axis setRotation(double rotation) {
        this.rotation = rotation;
        return this;
    }

    public Axis addLabel(String label, double location) {
        if (this.labels == null) {
            this.labels = new HashMap();
        }
        this.labels.put(label, location);
        this.setSlice();
        this.initGridLines();
        this.initGridLabels();
        return this;
    }

    public Axis addLabel(String[] label, double[] location) {
        if (label.length != location.length) {
            throw new IllegalArgumentException("Label size and location size don't match.");
        }
        if (this.labels == null) {
            this.labels = new HashMap();
        }
        for (int i = 0; i < label.length; ++i) {
            this.labels.put(label[i], location[i]);
        }
        this.setSlice();
        this.initGridLines();
        this.initGridLabels();
        return this;
    }

    public Axis removeLabel(String label) {
        if (this.labels == null) {
            throw new IllegalStateException();
        }
        this.labels.remove(label);
        this.setSlice();
        this.initGridLabels();
        return this;
    }

    public int getLinearSlices() {
        return this.linearSlices;
    }

    public Axis setGridVisible(boolean v) {
        this.gridVisible = v;
        return this;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public Axis setFrameVisible(boolean v) {
        this.frameVisible = v;
        return this;
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public Axis setLabelVisible(boolean v) {
        this.labelVisible = v;
        return this;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public Axis setAxisLabel(String label) {
        if (label == null) {
            if (this.index == 0) {
                label = "X";
            } else if (this.index == 1) {
                label = "Y";
            } else if (this.index == 2) {
                label = "Z";
            }
        }
        if (label != null) {
            double[] position = new double[this.base.getDimension()];
            if (this.base.getDimension() == 2) {
                position[this.index] = 0.5;
                if (this.index == 0) {
                    position[1] = -0.1;
                    this.axisLabel = new BaseLabel(label, 0.5, 1.0, position);
                } else {
                    position[0] = -0.15;
                    this.axisLabel = new BaseLabel(label, 0.5, 0.5, -1.5707963267948966, position);
                }
            } else if (this.index == 0) {
                position[2] = 1.0;
                position[this.index] = 0.5;
                this.axisLabel = new BaseLabel(label, 0.5, -2.0, position);
            } else if (this.index == 1) {
                position[0] = 1.0;
                position[this.index] = 0.5;
                this.axisLabel = new BaseLabel(label, 0.5, 3.0, position);
            } else if (this.index == 2) {
                position[1] = 1.0;
                position[this.index] = 1.0;
                this.axisLabel = new BaseLabel(label, -0.5, -1.0, position);
            }
            this.axisLabel.setFont(axisLabelFont);
        }
        return this;
    }

    public String getAxisLabel() {
        if (this.axisLabel == null) {
            return null;
        }
        return this.axisLabel.getText();
    }

    public void paint(Graphics g) {
        if (this.gridLines != null) {
            int i;
            if (this.gridVisible) {
                for (i = 0; i < this.gridLines.length; ++i) {
                    for (int j = 1; j < this.gridLines[i].length - 1; ++j) {
                        this.gridLines[i][j].paint(g);
                    }
                }
            }
            if (this.frameVisible) {
                for (i = 0; i < this.gridLines.length; ++i) {
                    this.gridLines[i][0].paint(g);
                    this.gridLines[i][this.gridLines[i].length - 1].paint(g);
                }
            }
        }
        if (this.labelVisible) {
            if (this.gridLabels != null) {
                int[] xy = g.projection.screenProjection(this.gridLabels[1].getCoordinate());
                int prevx = xy[0];
                int prevy = xy[1];
                for (int i = 0; i < this.gridLabels.length; ++i) {
                    if (this.gridLabels[i].text.isEmpty()) continue;
                    double[] coord = this.gridLabels[i].getCoordinate();
                    xy = g.projection.screenProjection(coord);
                    int x = xy[0];
                    int y = xy[1];
                    if (this.base.getDimension() == 2 && this.index == 0 && this.rotation != 0.0) {
                        if ((prevx != x || prevy != y) && Math.abs((int)(x - prevx)) <= this.gridLabels[i].font.getSize()) continue;
                        this.gridLabels[i].paint(g);
                        prevx = x;
                        prevy = y;
                        continue;
                    }
                    if (this.base.getDimension() == 2 && this.index == 1) {
                        if ((prevx != x || prevy != y || i != 0) && Math.abs((int)(prevy - y)) <= this.gridLabels[i].font.getSize()) continue;
                        this.gridLabels[i].paint(g);
                        prevx = x;
                        prevy = y;
                        continue;
                    }
                    if ((prevx != x || prevy != y) && Math.abs((int)(x - prevx)) <= g.g2d.getFontMetrics(this.gridLabels[i].font).stringWidth(this.gridLabels[i].text) && Math.abs((int)(prevy - y)) <= this.gridLabels[i].font.getSize()) continue;
                    this.gridLabels[i].paint(g);
                    prevx = x;
                    prevy = y;
                }
            }
            if (this.axisLabel != null) {
                this.axisLabel.paint(g);
            }
        }
    }
}

