/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;
import smile.plot.Projection3D;
import smile.sort.QuickSort;

public class Histogram3D
extends Plot {
    private double[][] freq;
    private double[][] topNW;
    private double[][] topNE;
    private double[][] topSW;
    private double[][] topSE;
    private double[][] bottomNW;
    private double[][] bottomNE;
    private double[][] bottomSW;
    private double[][] bottomSE;
    private double[] zTopNW;
    private double[] zTopNE;
    private double[] zTopSW;
    private double[] zTopSE;
    private double[] zBottomNW;
    private double[] zBottomNE;
    private double[] zBottomSW;
    private double[] zBottomSE;
    private double[] z;
    private int[] order;
    private double max;
    private double width = 1.0;
    private Color[] palette = null;

    public Histogram3D(double[][] data) {
        this(data, true);
    }

    public Histogram3D(double[][] data, Color[] palette) {
        this(data, true, palette);
    }

    public Histogram3D(double[][] data, boolean prob) {
        this(data, 10);
    }

    public Histogram3D(double[][] data, boolean prob, Color[] palette) {
        this(data, 10, palette);
    }

    public Histogram3D(double[][] data, int nbins) {
        this(data, nbins, nbins, true);
    }

    public Histogram3D(double[][] data, int nbins, Color[] palette) {
        this(data, nbins, nbins, true, palette);
    }

    public Histogram3D(double[][] data, int nbins, boolean prob) {
        this(data, nbins, nbins, prob);
    }

    public Histogram3D(double[][] data, int nbins, boolean prob, Color[] palette) {
        this(data, nbins, nbins, prob, palette);
    }

    public Histogram3D(double[][] data, int xbins, int ybins) {
        this(data, xbins, ybins, true);
    }

    public Histogram3D(double[][] data, int xbins, int ybins, Color[] palette) {
        this(data, xbins, ybins, true, palette);
    }

    public Histogram3D(double[][] data, int xbins, int ybins, boolean prob) {
        super(Color.LIGHT_GRAY);
        this.init(data, xbins, ybins, prob);
    }

    public Histogram3D(double[][] data, int xbins, int ybins, boolean prob, Color[] palette) {
        super(Color.LIGHT_GRAY);
        this.palette = palette;
        this.init(data, xbins, ybins, prob);
    }

    private void init(double[][] data, int xbins, int ybins, boolean prob) {
        int i;
        if (data.length == 0) {
            throw new IllegalArgumentException("array is empty.");
        }
        if (data[0].length != 2) {
            throw new IllegalArgumentException("dimension is not 2.");
        }
        double xmin = data[0][0];
        double xmax = data[0][0];
        double ymin = data[0][1];
        double ymax = data[0][1];
        for (int i2 = 1; i2 < data.length; ++i2) {
            if (xmin > data[i2][0]) {
                xmin = data[i2][0];
            }
            if (xmax < data[i2][0]) {
                xmax = data[i2][0];
            }
            if (ymin > data[i2][1]) {
                ymin = data[i2][1];
            }
            if (!(ymax < data[i2][1])) continue;
            ymax = data[i2][1];
        }
        double xspan = xmax - xmin;
        double xwidth = xspan / (double)xbins;
        double yspan = ymax - ymin;
        double ywidth = yspan / (double)ybins;
        this.freq = new double[xbins * ybins][3];
        this.freq[0][0] = xmin + xwidth / 2.0;
        this.freq[0][1] = ymin + ywidth / 2.0;
        for (i = 0; i < xbins; ++i) {
            for (int j = 0; j < ybins; ++j) {
                this.freq[j * xbins + i][0] = this.freq[0][0] + xwidth * (double)i;
                this.freq[j * xbins + i][1] = this.freq[0][1] + ywidth * (double)j;
            }
        }
        for (int k = 0; k < data.length; ++k) {
            int j;
            int i3 = (int)((data[k][0] - xmin) / xwidth);
            if (i3 >= xbins) {
                i3 = xbins - 1;
            }
            if ((j = (int)((data[k][1] - ymin) / ywidth)) >= ybins) {
                j = ybins - 1;
            }
            double[] dArray = this.freq[j * xbins + i3];
            dArray[2] = dArray[2] + 1.0;
        }
        if (prob) {
            for (i = 0; i < this.freq.length; ++i) {
                double[] dArray = this.freq[i];
                dArray[2] = dArray[2] / (double)data.length;
            }
        }
        this.max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.freq.length; ++i) {
            if (!(this.freq[i][2] > this.max)) continue;
            this.max = this.freq[i][2];
        }
        if (this.palette != null) {
            this.width = this.max / (double)this.palette.length;
        }
        this.topNW = new double[this.freq.length][3];
        this.topNE = new double[this.freq.length][3];
        this.topSW = new double[this.freq.length][3];
        this.topSE = new double[this.freq.length][3];
        this.bottomNW = new double[this.freq.length][3];
        this.bottomNE = new double[this.freq.length][3];
        this.bottomSW = new double[this.freq.length][3];
        this.bottomSE = new double[this.freq.length][3];
        for (i = 0; i < this.freq.length; ++i) {
            this.topNW[i][0] = this.freq[i][0] - xwidth / 2.0;
            this.topNW[i][1] = this.freq[i][1] + ywidth / 2.0;
            this.topNW[i][2] = this.freq[i][2];
            this.topNE[i][0] = this.freq[i][0] + xwidth / 2.0;
            this.topNE[i][1] = this.freq[i][1] + ywidth / 2.0;
            this.topNE[i][2] = this.freq[i][2];
            this.topSW[i][0] = this.freq[i][0] - xwidth / 2.0;
            this.topSW[i][1] = this.freq[i][1] - ywidth / 2.0;
            this.topSW[i][2] = this.freq[i][2];
            this.topSE[i][0] = this.freq[i][0] + xwidth / 2.0;
            this.topSE[i][1] = this.freq[i][1] - ywidth / 2.0;
            this.topSE[i][2] = this.freq[i][2];
            this.bottomNW[i][0] = this.freq[i][0] - xwidth / 2.0;
            this.bottomNW[i][1] = this.freq[i][1] + ywidth / 2.0;
            this.bottomNW[i][2] = 0.0;
            this.bottomNE[i][0] = this.freq[i][0] + xwidth / 2.0;
            this.bottomNE[i][1] = this.freq[i][1] + ywidth / 2.0;
            this.bottomNE[i][2] = 0.0;
            this.bottomSW[i][0] = this.freq[i][0] - xwidth / 2.0;
            this.bottomSW[i][1] = this.freq[i][1] - ywidth / 2.0;
            this.bottomSW[i][2] = 0.0;
            this.bottomSE[i][0] = this.freq[i][0] + xwidth / 2.0;
            this.bottomSE[i][1] = this.freq[i][1] - ywidth / 2.0;
            this.bottomSE[i][2] = 0.0;
        }
        this.z = new double[6 * this.freq.length];
        this.order = new int[6 * this.freq.length];
        this.zTopNW = new double[this.freq.length];
        this.zTopNE = new double[this.freq.length];
        this.zTopSW = new double[this.freq.length];
        this.zTopSE = new double[this.freq.length];
        this.zBottomNW = new double[this.freq.length];
        this.zBottomNE = new double[this.freq.length];
        this.zBottomSW = new double[this.freq.length];
        this.zBottomSE = new double[this.freq.length];
    }

    @Override
    public void paint(Graphics g) {
        int i;
        Color c = g.getColor();
        Projection3D p3d = (Projection3D)g.projection;
        for (i = 0; i < this.freq.length; ++i) {
            this.zTopNW[i] = p3d.z(this.topNW[i]);
            this.zTopNE[i] = p3d.z(this.topNE[i]);
            this.zTopSW[i] = p3d.z(this.topSW[i]);
            this.zTopSE[i] = p3d.z(this.topSE[i]);
            this.zBottomNW[i] = p3d.z(this.bottomNW[i]);
            this.zBottomNE[i] = p3d.z(this.bottomNE[i]);
            this.zBottomSW[i] = p3d.z(this.bottomSW[i]);
            this.zBottomSE[i] = p3d.z(this.bottomSE[i]);
        }
        i = 0;
        int k = 0;
        while (i < this.freq.length) {
            this.z[k] = this.zTopNW[i] + this.zTopNE[i] + this.zTopSE[i] + this.zTopSW[i];
            this.z[k + 1] = this.zTopNW[i] + this.zTopNE[i] + this.zBottomNE[i] + this.zBottomNW[i];
            this.z[k + 2] = this.zTopSW[i] + this.zTopSE[i] + this.zBottomSE[i] + this.zBottomSW[i];
            this.z[k + 3] = this.zTopNE[i] + this.zTopSE[i] + this.zBottomSE[i] + this.zBottomNE[i];
            this.z[k + 4] = this.zTopNW[i] + this.zTopSW[i] + this.zBottomSW[i] + this.zBottomNW[i];
            this.z[k + 5] = this.zBottomNW[i] + this.zBottomNE[i] + this.zBottomSE[i] + this.zBottomSW[i];
            ++i;
            k += 6;
        }
        for (i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
        QuickSort.sort((double[])this.z, (int[])this.order);
        block11: for (int k2 : this.order) {
            int i2 = k2 / 6;
            if (this.topNW[i2][2] == this.bottomNW[i2][2]) continue;
            if (this.palette == null) {
                g.setColor(this.getColor());
            } else {
                int p = (int)(this.freq[i2][2] / this.width);
                if (p == this.palette.length) {
                    p = this.palette.length - 1;
                }
                g.setColor(this.palette[p]);
            }
            int j = k2 % 6;
            switch (j) {
                case 0: {
                    g.fillPolygon(this.topNW[i2], this.topNE[i2], this.topSE[i2], this.topSW[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.topNW[i2], this.topNE[i2]);
                    g.drawLine(this.topNE[i2], this.topSE[i2]);
                    g.drawLine(this.topSE[i2], this.topSW[i2]);
                    g.drawLine(this.topSW[i2], this.topNW[i2]);
                    continue block11;
                }
                case 1: {
                    g.fillPolygon(this.topNW[i2], this.topNE[i2], this.bottomNE[i2], this.bottomNW[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.topNW[i2], this.topNE[i2]);
                    g.drawLine(this.bottomNW[i2], this.topNW[i2]);
                    g.drawLine(this.bottomNE[i2], this.topNE[i2]);
                    g.drawLine(this.bottomNE[i2], this.bottomNW[i2]);
                    continue block11;
                }
                case 2: {
                    g.fillPolygon(this.topSW[i2], this.topSE[i2], this.bottomSE[i2], this.bottomSW[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.topSW[i2], this.topSE[i2]);
                    g.drawLine(this.bottomSW[i2], this.topSW[i2]);
                    g.drawLine(this.bottomSE[i2], this.topSE[i2]);
                    g.drawLine(this.bottomSE[i2], this.bottomSW[i2]);
                    continue block11;
                }
                case 3: {
                    g.fillPolygon(this.topNE[i2], this.topSE[i2], this.bottomSE[i2], this.bottomNE[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.topNE[i2], this.topSE[i2]);
                    g.drawLine(this.bottomSE[i2], this.topSE[i2]);
                    g.drawLine(this.bottomNE[i2], this.topNE[i2]);
                    g.drawLine(this.bottomSE[i2], this.bottomNE[i2]);
                    continue block11;
                }
                case 4: {
                    g.fillPolygon(this.topNW[i2], this.topSW[i2], this.bottomSW[i2], this.bottomNW[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.topNW[i2], this.topSW[i2]);
                    g.drawLine(this.bottomNW[i2], this.topNW[i2]);
                    g.drawLine(this.bottomSW[i2], this.topSW[i2]);
                    g.drawLine(this.bottomNW[i2], this.bottomSW[i2]);
                    continue block11;
                }
                case 5: {
                    g.fillPolygon(this.bottomNW[i2], this.bottomNE[i2], this.bottomSE[i2], this.bottomSW[i2]);
                    g.setColor(Color.BLACK);
                    g.drawLine(this.bottomNW[i2], this.bottomNE[i2]);
                    g.drawLine(this.bottomNE[i2], this.bottomSE[i2]);
                    g.drawLine(this.bottomSE[i2], this.bottomSW[i2]);
                    g.drawLine(this.bottomSW[i2], this.bottomNW[i2]);
                }
            }
        }
        g.setColor(c);
    }

    public double[][] getHistogram() {
        return this.freq;
    }

    public static PlotCanvas plot(double[][] data) {
        return Histogram3D.plot(data);
    }

    public static PlotCanvas plot(double[][] data, Color[] palette) {
        Histogram3D histogram = new Histogram3D(data, palette);
        double[] min = Math.colMin((double[][])data);
        double[] max = Math.colMax((double[][])data);
        double[] lowerBound = new double[]{min[0], min[1], 0.0};
        double[] upperBound = new double[]{max[0], max[1], 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][2] > upperBound[2])) continue;
            upperBound[2] = freq[i][2];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, int k) {
        return Histogram3D.plot(data, k, null);
    }

    public static PlotCanvas plot(double[][] data, int k, Color[] palette) {
        return Histogram3D.plot(data, k, false, palette);
    }

    public static PlotCanvas plot(double[][] data, int k, boolean prob, Color[] palette) {
        return Histogram3D.plot(data, k, k, prob, palette);
    }

    public static PlotCanvas plot(double[][] data, int xbins, int ybins, boolean prob, Color[] palette) {
        Histogram3D histogram = new Histogram3D(data, xbins, ybins, prob, palette);
        double[] min = Math.colMin((double[][])data);
        double[] max = Math.colMax((double[][])data);
        double[] lowerBound = new double[]{min[0], min[1], 0.0};
        double[] upperBound = new double[]{max[0], max[1], 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][2] > upperBound[2])) continue;
            upperBound[2] = freq[i][2];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, int xbins, int ybins) {
        return Histogram3D.plot(data, xbins, ybins, null);
    }

    public static PlotCanvas plot(double[][] data, int xbins, int ybins, Color[] palette) {
        Histogram3D histogram = new Histogram3D(data, xbins, ybins, palette);
        double[] min = Math.colMin((double[][])data);
        double[] max = Math.colMax((double[][])data);
        double[] lowerBound = new double[]{min[0], min[1], 0.0};
        double[] upperBound = new double[]{max[0], max[1], 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][2] > upperBound[2])) continue;
            upperBound[2] = freq[i][2];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(histogram);
        return canvas;
    }
}

