/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;

public class Hexmap
extends Plot {
    private double[][] z;
    private Tooltip tooltip;
    private double[][][][] hexagon;
    private double min;
    private double max;
    private double width;
    private Color[] palette;

    public Hexmap(double[][] z, Color[] palette, Tooltip tooltip) {
        this.z = z;
        this.palette = palette;
        this.tooltip = tooltip;
        double s = Math.sqrt(0.75);
        this.hexagon = new double[z.length][z[0].length][6][2];
        for (int i = 0; i < z.length; ++i) {
            for (int j = 0; j < z[i].length; ++j) {
                for (int r = 0; r < this.hexagon[i][j].length; ++r) {
                    double a = 1.0471975511965976 * (double)r;
                    this.hexagon[i][j][r][0] = (double)j + Math.sin(a) / 2.0;
                    if (i % 2 == 1) {
                        double[] dArray = this.hexagon[i][j][r];
                        dArray[0] = dArray[0] + 0.5;
                    }
                    this.hexagon[i][j][r][1] = (double)(z.length - i) * s + Math.cos(a) / 2.0;
                }
            }
        }
        int n = z.length * z[0].length;
        double[] values = new double[n];
        int i = 0;
        double[][] dArray = z;
        int n2 = dArray.length;
        for (int j = 0; j < n2; ++j) {
            double[] zi;
            for (double zij : zi = dArray[j]) {
                if (Double.isNaN(zij)) continue;
                values[i++] = zij;
            }
        }
        if (i > 0) {
            Arrays.sort(values, 0, i);
            this.min = values[(int)Math.round(0.01 * (double)i)];
            this.max = values[(int)Math.round(0.99 * (double)(i - 1))];
            this.width = (this.max - this.min) / (double)palette.length;
        }
    }

    @Override
    public Optional<String> tooltip(double[] coord) {
        if (this.tooltip == null) {
            return Optional.empty();
        }
        if (coord[0] < -0.5 || coord[0] > (double)this.z[0].length || coord[1] < 0.36 || coord[1] > (double)this.z.length * 0.87 + 0.5) {
            return Optional.empty();
        }
        int x = (int)(coord[0] + 0.5);
        int y = (int)((double)this.z.length - (coord[1] - 0.5) / 0.87);
        for (int i = -3; i < 3; ++i) {
            for (int j = -3; j < 3; ++j) {
                int xi = x + i;
                int yj = y + j;
                if (xi < 0 || xi >= this.hexagon[0].length || yj < 0 || yj >= this.hexagon.length || !MathEx.contains((double[][])this.hexagon[yj][xi], (double[])coord)) continue;
                return Optional.of(this.tooltip.get(yj, xi));
            }
        }
        return Optional.empty();
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{-0.5, 0.36};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{this.z[0].length, (double)this.z.length * 0.87 + 0.5};
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        for (int i = 0; i < this.z.length; ++i) {
            for (int j = 0; j < this.z[i].length; ++j) {
                if (Double.isNaN(this.z[i][j])) {
                    g.setColor(Color.WHITE);
                } else {
                    int k = (int)((this.z[i][j] - this.min) / this.width);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= this.palette.length) {
                        k = this.palette.length - 1;
                    }
                    g.setColor(this.palette[k]);
                }
                g.fillPolygon(this.hexagon[i][j]);
            }
        }
        g.clearClip();
        double height = 0.7 / (double)this.palette.length;
        double[] start = new double[]{1.1, 0.15};
        double[] end = new double[]{1.13, start[1] - height};
        for (int i = 0; i < this.palette.length; ++i) {
            g.setColor(this.palette[i]);
            g.fillRectBaseRatio(start, end);
            start[1] = start[1] + height;
            end[1] = end[1] + height;
        }
        g.setColor(Color.BLACK);
        start[1] = start[1] - height;
        end[1] = 0.15 - height;
        g.drawRectBaseRatio(start, end);
        start[0] = 1.14;
        double log = Math.log10(Math.abs(this.max));
        int decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.max, (int)decimal)), start, 0.0, 1.0);
        start[1] = 0.15 - height;
        log = Math.log10(Math.abs(this.min));
        decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.min, (int)decimal)), start, 0.0, 0.0);
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.add(this);
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setTickVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setTickVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static Hexmap of(double[][] z) {
        return Hexmap.of(z, 16);
    }

    public static Hexmap of(double[][] z, int k) {
        return Hexmap.of(z, Palette.jet(k, 1.0f));
    }

    public static Hexmap of(double[][] z, Color[] palette) {
        return new Hexmap(z, palette, null);
    }

    public static interface Tooltip {
        public String get(int var1, int var2);
    }
}

