/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Arrays;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;

public class SparseMatrixPlot
extends Plot {
    private SparseMatrix sparse;
    private double[] x;
    private double[] y;
    private double min;
    private double max;
    private double width;
    private Color[] palette;

    public SparseMatrixPlot(SparseMatrix sparse, Color color) {
        super(color);
        int i;
        this.sparse = sparse;
        int m = sparse.nrows();
        int n = sparse.ncols();
        this.x = new double[n];
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (double)i + 0.5;
        }
        this.y = new double[m];
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (double)(this.y.length - i) - 0.5;
        }
    }

    public SparseMatrixPlot(SparseMatrix sparse, Color[] palette) {
        int i;
        this.sparse = sparse;
        this.palette = palette;
        int m = sparse.nrows();
        int n = sparse.ncols();
        this.x = new double[n];
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (double)i + 0.5;
        }
        this.y = new double[m];
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (double)(this.y.length - i) - 0.5;
        }
        double[] values = sparse.nonzeros().mapToDouble(e -> e.x).filter(x -> !Double.isNaN(x)).toArray();
        if (values.length == 0) {
            throw new IllegalArgumentException("Sparse matrix has no non-zero values");
        }
        Arrays.sort(values);
        this.min = values[(int)Math.round(0.01 * (double)values.length)];
        this.max = values[(int)Math.round(0.99 * (double)(values.length - 1))];
        this.width = (this.max - this.min) / (double)palette.length;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{0.0, 0.0};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{this.sparse.ncols(), this.sparse.nrows()};
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        double[] start = new double[2];
        double[] end = new double[2];
        g.setColor(this.color);
        for (SparseMatrix.Entry cell : this.sparse) {
            i = cell.i;
            int j = cell.j;
            double z = cell.x;
            if (this.palette != null) {
                int k = (int)((z - this.min) / this.width);
                if (k < 0) {
                    k = 0;
                }
                if (k >= this.palette.length) {
                    k = this.palette.length - 1;
                }
                g.setColor(this.palette[k]);
            }
            start[0] = this.x[j];
            start[0] = j == 0 ? start[0] - Math.abs(this.x[j + 1] - this.x[j]) / 2.0 : start[0] - Math.abs(this.x[j] - this.x[j - 1]) / 2.0;
            start[1] = this.y[i];
            start[1] = i == 0 ? start[1] + Math.abs(this.y[i + 1] - this.y[i]) / 2.0 : start[1] + Math.abs(this.y[i] - this.y[i - 1]) / 2.0;
            end[0] = this.x[j];
            end[0] = j == this.x.length - 1 ? end[0] + Math.abs(this.x[j] - this.x[j - 1]) / 2.0 : end[0] + Math.abs(this.x[j + 1] - this.x[j]) / 2.0;
            end[1] = this.y[i];
            end[1] = i == this.y.length - 1 ? end[1] - Math.abs(this.y[i] - this.y[i - 1]) / 2.0 : end[1] - Math.abs(this.y[i + 1] - this.y[i]) / 2.0;
            g.fillRect(start, end);
        }
        if (this.palette != null) {
            g.clearClip();
            double height = 0.7 / (double)this.palette.length;
            start[0] = 1.1;
            start[1] = 0.15;
            end[0] = 1.13;
            end[1] = start[1] - height;
            for (i = 0; i < this.palette.length; ++i) {
                g.setColor(this.palette[i]);
                g.fillRectBaseRatio(start, end);
                start[1] = start[1] + height;
                end[1] = end[1] + height;
            }
            g.setColor(Color.BLACK);
            start[1] = start[1] - height;
            end[1] = 0.15 - height;
            g.drawRectBaseRatio(start, end);
            start[0] = 1.14;
            double log = Math.log10(Math.abs(this.max));
            int decimal = 1;
            if (log < 0.0) {
                decimal = (int)(-log) + 1;
            }
            g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.max, (int)decimal)), start, 0.0, 1.0);
            start[1] = 0.15 - height;
            log = Math.log10(Math.abs(this.min));
            decimal = 1;
            if (log < 0.0) {
                decimal = (int)(-log) + 1;
            }
            g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.min, (int)decimal)), start, 0.0, 0.0);
        }
    }

    @Override
    public Canvas canvas() {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{this.sparse.ncols(), this.sparse.nrows()};
        Canvas canvas = new Canvas(lowerBound, upperBound, false);
        canvas.add(this);
        canvas.getAxis(0).setTickVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setTickVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static SparseMatrixPlot of(SparseMatrix sparse) {
        return new SparseMatrixPlot(sparse, Color.BLUE);
    }

    public static SparseMatrixPlot of(SparseMatrix sparse, int k) {
        return new SparseMatrixPlot(sparse, Palette.jet(k, 1.0f));
    }
}

