/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Arrays;
import smile.math.MathEx;
import smile.plot.swing.Base;
import smile.plot.swing.BaseLabel;
import smile.plot.swing.Graphics;
import smile.plot.swing.GridLabel;
import smile.plot.swing.Line;
import smile.sort.QuickSort;

public class Axis {
    private Base base;
    private int index;
    private String[] ticks;
    private double[] location;
    private boolean isTickVisible = true;
    private boolean isGridVisible = true;
    private boolean isFrameVisible = true;
    private int slices = 10;
    private double[] origin;
    private BaseLabel axisLabel;
    private Line[][] gridLines;
    private GridLabel[] gridLabels;
    private double rotation = 0.0;

    public Axis(Base base, int index) {
        this.base = base;
        this.index = index;
        String label = "";
        switch (index) {
            case 0: {
                label = "X";
                break;
            }
            case 1: {
                label = "Y";
                break;
            }
            case 2: {
                label = "Z";
            }
        }
        this.setLabel(label);
        this.init();
    }

    private void init() {
        this.initOrigin();
        this.setTicks();
    }

    private void initOrigin() {
        this.origin = this.base.getCoordinateSpace()[0];
    }

    private void setTicks() {
        int i;
        double[] tickLocation;
        double[] gridLocation;
        Object[] marks = null;
        if (this.ticks == null || this.location == null) {
            double min = this.base.getPrecisionUnit()[this.index] * Math.ceil(this.base.getLowerBounds()[this.index] / this.base.getPrecisionUnit()[this.index]);
            double max = this.base.getPrecisionUnit()[this.index] * Math.floor(this.base.getUpperBounds()[this.index] / this.base.getPrecisionUnit()[this.index]);
            this.slices = (int)Math.ceil(MathEx.round((double)((max - min) / this.base.getPrecisionUnit()[this.index]), (int)1));
            if (this.slices <= 0) {
                this.slices = 1;
            }
            if (this.slices < 3) {
                this.slices *= 2;
            }
            gridLocation = new double[this.slices + 3];
            tickLocation = new double[this.slices + 3];
            double pitch = (max - min) / (double)this.slices;
            for (int i2 = 1; i2 <= this.slices + 1; ++i2) {
                gridLocation[i2] = min + (double)(i2 - 1) * pitch;
                tickLocation[i2] = min + (double)(i2 - 1) * pitch;
            }
            gridLocation[0] = this.base.getLowerBounds()[this.index];
            tickLocation[0] = this.base.getLowerBounds()[this.index];
            gridLocation[this.slices + 2] = this.base.getUpperBounds()[this.index];
            tickLocation[this.slices + 2] = this.base.getUpperBounds()[this.index];
        } else {
            gridLocation = new double[this.ticks.length + 2];
            tickLocation = new double[this.ticks.length];
            marks = new String[this.ticks.length];
            gridLocation[0] = this.base.getLowerBounds()[this.index];
            gridLocation[gridLocation.length - 1] = this.base.getUpperBounds()[this.index];
            for (int i3 = 0; i3 < this.ticks.length; ++i3) {
                gridLocation[i3 + 1] = this.location[i3];
                tickLocation[i3] = this.location[i3];
                marks[i3] = this.ticks[i3];
            }
            Arrays.sort(gridLocation);
            QuickSort.sort((double[])tickLocation, (Object[])marks);
        }
        int dim = this.base.getDimension();
        double[] offset = new double[dim];
        for (int j = 0; j < dim; ++j) {
            if (j == this.index) continue;
            offset[j] = -(this.base.getUpperBounds()[j] - this.base.getLowerBounds()[j]) / 100.0;
        }
        this.gridLabels = new GridLabel[tickLocation.length];
        for (i = 0; i < this.gridLabels.length; ++i) {
            Object label;
            double[] coord = new double[this.base.getDimension()];
            System.arraycopy(this.base.getCoordinateSpace()[this.index + 1], 0, coord, 0, this.base.getDimension());
            coord[this.index] = tickLocation[i];
            if (dim == 3) {
                if (this.index == 0) {
                    coord[2] = this.base.getUpperBounds()[2] - 2.0 * offset[2];
                } else if (this.index == 1) {
                    coord[0] = this.base.getUpperBounds()[0] - 2.0 * offset[0];
                } else if (this.index == 2) {
                    coord[1] = this.base.getUpperBounds()[1] - 2.0 * offset[1];
                }
            }
            if (marks != null) {
                label = marks[i % marks.length];
            } else {
                int decimal = this.base.getPrecisionDigits()[this.index];
                if (this.ticks == null && (i == 0 && tickLocation[0] != tickLocation[1] || i == this.gridLabels.length - 1 && tickLocation[this.gridLabels.length - 1] != tickLocation[this.gridLabels.length - 2])) {
                    --decimal;
                }
                String format = "%.0f";
                if (decimal < 0) {
                    format = String.format("%%.%df", -decimal);
                }
                label = String.format(format, tickLocation[i]);
            }
            for (int j = 0; j < dim; ++j) {
                int n = j;
                coord[n] = coord[n] + offset[j];
            }
            if (this.base.getDimension() == 2) {
                if (this.index == 0 && this.rotation == 0.0) {
                    this.gridLabels[i] = new GridLabel((String)label, coord, 0.5, 1.0, this.rotation);
                    continue;
                }
                this.gridLabels[i] = new GridLabel((String)label, coord, 1.0, 0.5, this.rotation);
                continue;
            }
            if (this.index == 0) {
                this.gridLabels[i] = new GridLabel((String)label, coord, 0.5, -0.5, this.rotation);
                continue;
            }
            if (this.index == 1) {
                this.gridLabels[i] = new GridLabel((String)label, coord, 0.5, 1.0, this.rotation);
                continue;
            }
            if (this.index != 2) continue;
            this.gridLabels[i] = new GridLabel((String)label, coord, 0.0, 0.5, this.rotation);
        }
        this.gridLines = new Line[this.base.getDimension() - 1][gridLocation.length];
        int i2 = 0;
        for (i = 0; i < this.base.getDimension() - 1; ++i) {
            if (i2 == this.index) {
                ++i2;
            }
            for (int j = 0; j < this.gridLines[i].length; ++j) {
                double[] originBase = new double[this.base.getDimension()];
                double[] endBase = new double[this.base.getDimension()];
                System.arraycopy(this.origin, 0, originBase, 0, this.base.getDimension());
                System.arraycopy(this.origin, 0, endBase, 0, this.base.getDimension());
                endBase[i2] = this.base.getCoordinateSpace()[i2 + 1][i2];
                originBase[this.index] = gridLocation[j];
                endBase[this.index] = gridLocation[j];
                double[][] points = new double[][]{originBase, endBase};
                this.gridLines[i][j] = j > 0 && j < this.gridLines[i].length - 1 ? new Line(points, Line.Style.DOT, ' ', Color.LIGHT_GRAY) : new Line(points, Line.Style.SOLID, ' ', Color.BLACK);
            }
            ++i2;
        }
    }

    public void reset() {
        this.init();
    }

    public Axis setRotation(double rotation) {
        this.rotation = rotation;
        return this;
    }

    public void setTicks(String[] ticks, double[] location) {
        if (ticks.length != location.length) {
            throw new IllegalArgumentException("Tick and location size don't match.");
        }
        this.ticks = ticks;
        this.location = location;
        this.setTicks();
    }

    public int slices() {
        return this.slices;
    }

    public Axis setGridVisible(boolean v) {
        this.isGridVisible = v;
        return this;
    }

    public boolean isGridVisible() {
        return this.isGridVisible;
    }

    public Axis setFrameVisible(boolean v) {
        this.isFrameVisible = v;
        return this;
    }

    public boolean isFrameVisible() {
        return this.isFrameVisible;
    }

    public Axis setTickVisible(boolean v) {
        this.isTickVisible = v;
        return this;
    }

    public boolean isTickVisible() {
        return this.isTickVisible;
    }

    public void setLabel(String label) {
        if (label == null) {
            this.axisLabel = null;
            return;
        }
        double[] position = new double[this.base.getDimension()];
        if (this.base.getDimension() == 2) {
            position[this.index] = 0.5;
            if (this.index == 0) {
                position[1] = -0.1;
                this.axisLabel = new BaseLabel(label, position, 0.5, 1.0, 0.0);
            } else {
                position[0] = -0.15;
                this.axisLabel = new BaseLabel(label, position, 0.5, 0.5, -1.5707963267948966);
            }
        } else if (this.index == 0) {
            position[2] = 1.0;
            position[this.index] = 0.5;
            this.axisLabel = new BaseLabel(label, position, 0.5, -2.0, 0.0);
        } else if (this.index == 1) {
            position[0] = 1.0;
            position[this.index] = 0.5;
            this.axisLabel = new BaseLabel(label, position, 0.5, 3.0, 0.0);
        } else if (this.index == 2) {
            position[1] = 1.0;
            position[this.index] = 1.0;
            this.axisLabel = new BaseLabel(label, position, -0.5, -1.0, 0.0);
        }
    }

    public String getLabel() {
        if (this.axisLabel == null) {
            return null;
        }
        return this.axisLabel.text;
    }

    public void paint(Graphics g) {
        if (this.gridLines != null) {
            int i;
            if (this.isGridVisible) {
                for (i = 0; i < this.gridLines.length; ++i) {
                    for (int j = 1; j < this.gridLines[i].length - 1; ++j) {
                        this.gridLines[i][j].paint(g);
                    }
                }
            }
            if (this.isFrameVisible) {
                for (i = 0; i < this.gridLines.length; ++i) {
                    this.gridLines[i][0].paint(g);
                    this.gridLines[i][this.gridLines[i].length - 1].paint(g);
                }
            }
        }
        if (this.isTickVisible && this.gridLabels != null) {
            int[] xy = g.projection.screenProjection(this.gridLabels[1].coordinates);
            int prevx = xy[0];
            int prevy = xy[1];
            for (int i = 0; i < this.gridLabels.length; ++i) {
                if (this.gridLabels[i].text.isEmpty()) continue;
                double[] coord = this.gridLabels[i].coordinates;
                xy = g.projection.screenProjection(coord);
                int x = xy[0];
                int y = xy[1];
                if (this.base.getDimension() == 2 && this.index == 0 && this.rotation != 0.0) {
                    if ((prevx != x || prevy != y) && Math.abs(x - prevx) <= this.gridLabels[i].font.getSize()) continue;
                    this.gridLabels[i].paint(g);
                    prevx = x;
                    prevy = y;
                    continue;
                }
                if (this.base.getDimension() == 2 && this.index == 1) {
                    if ((prevx != x || prevy != y || i != 0) && Math.abs(prevy - y) <= this.gridLabels[i].font.getSize()) continue;
                    this.gridLabels[i].paint(g);
                    prevx = x;
                    prevy = y;
                    continue;
                }
                if ((prevx != x || prevy != y) && Math.abs(x - prevx) <= g.getGraphics().getFontMetrics(this.gridLabels[i].font).stringWidth(this.gridLabels[i].text) && Math.abs(prevy - y) <= this.gridLabels[i].font.getSize()) continue;
                this.gridLabels[i].paint(g);
                prevx = x;
                prevy = y;
            }
        }
        if (this.axisLabel != null) {
            this.axisLabel.paint(g);
        }
    }
}

