/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smile.plot.swing.Base;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;
import smile.plot.swing.Projection2D;
import smile.plot.swing.Projection3D;
import smile.plot.swing.Shape;
import smile.swing.Button;
import smile.swing.FileChooser;
import smile.swing.Printer;
import smile.swing.Table;

public class PlotPanel
extends JPanel {
    private Canvas canvas;
    private JCanvas contentPane;
    private JToolBar toolbar;
    private JPopupMenu popup;
    private JTable propertyTable;
    private transient Action saveAction = new SaveAction();
    private transient Action printAction = new PrintAction();
    private transient Action zoomInAction = new ZoomInAction();
    private transient Action zoomOutAction = new ZoomOutAction();
    private transient Action resetAction = new ResetAction();
    private transient Action enlargePlotAreaAction = new EnlargePlotAreaAction();
    private transient Action shrinkPlotAreaAction = new ShrinkPlotAreaAction();
    private transient Action propertyAction = new PropertyAction();
    private transient Action increaseHeightAction = new IncreaseHeightAction();
    private transient Action increaseWidthAction = new IncreaseWidthAction();
    private transient Action decreaseHeightAction = new DecreaseHeightAction();
    private transient Action decreaseWidthAction = new DecreaseWidthAction();
    private JScrollPane scrollPane;
    static AtomicInteger WindowCount = new AtomicInteger();

    public PlotPanel(Canvas canvas) {
        this.canvas = canvas;
        this.contentPane = new JCanvas();
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.initContextMenauAndToolBar();
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    private void initContextMenauAndToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.add(new Button(this.saveAction));
        this.toolbar.add(new Button(this.printAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.zoomInAction));
        this.toolbar.add(new Button(this.zoomOutAction));
        this.toolbar.add(new Button(this.resetAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.enlargePlotAreaAction));
        this.toolbar.add(new Button(this.shrinkPlotAreaAction));
        this.toolbar.add(new Button(this.increaseHeightAction));
        this.toolbar.add(new Button(this.decreaseHeightAction));
        this.toolbar.add(new Button(this.increaseWidthAction));
        this.toolbar.add(new Button(this.decreaseWidthAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.propertyAction));
        this.decreaseHeightAction.setEnabled(false);
        this.decreaseWidthAction.setEnabled(false);
        this.popup = new JPopupMenu();
        this.popup.add(new JMenuItem(this.saveAction));
        this.popup.add(new JMenuItem(this.printAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.zoomInAction));
        this.popup.add(new JMenuItem(this.zoomOutAction));
        this.popup.add(new JMenuItem(this.resetAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.enlargePlotAreaAction));
        this.popup.add(new JMenuItem(this.shrinkPlotAreaAction));
        this.popup.add(new JMenuItem(this.increaseHeightAction));
        this.popup.add(new JMenuItem(this.decreaseHeightAction));
        this.popup.add(new JMenuItem(this.increaseWidthAction));
        this.popup.add(new JMenuItem(this.decreaseWidthAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.propertyAction));
        AncestorListener ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                boolean inScrollPane = false;
                for (Container parent = PlotPanel.this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof JScrollPane)) continue;
                    inScrollPane = true;
                    PlotPanel.this.scrollPane = (JScrollPane)parent;
                    break;
                }
                PlotPanel.this.increaseHeightAction.setEnabled(inScrollPane);
                PlotPanel.this.increaseWidthAction.setEnabled(inScrollPane);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        };
        this.addAncestorListener(ancestorListener);
    }

    private JDialog createPropertyDialog() {
        Object[][] data;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        JDialog dialog = new JDialog(frame, "Plot Properties", true);
        PropertyDialogOKAction okAction = new PropertyDialogOKAction(dialog);
        PropertyDialogCancelAction cancelAction = new PropertyDialogCancelAction(dialog);
        JButton okButton = new JButton(okAction);
        JButton cancelButton = new JButton(cancelAction);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(4));
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(25, 0, 10, 10));
        ActionMap actionMap = buttonsPanel.getActionMap();
        actionMap.put(cancelAction.getValue("Default"), cancelAction);
        actionMap.put(okAction.getValue("Default"), okAction);
        InputMap inputMap = buttonsPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), cancelAction.getValue("Default"));
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), okAction.getValue("Default"));
        Object[] columnNames = new String[]{"Property", "Value"};
        Base base = this.canvas.base;
        if (this.canvas.base.dimension == 2) {
            data = new Object[][]{{"Title", this.canvas.getTitle()}, {"Title Font", this.canvas.getTitleFont()}, {"Title Color", this.canvas.getTitleColor()}, {"X Axis Title", this.canvas.getAxis(0).getLabel()}, {"X Axis Range", new double[]{base.getLowerBounds()[0], base.getUpperBounds()[0]}}, {"Y Axis Title", this.canvas.getAxis(1).getLabel()}, {"Y Axis Range", new double[]{base.getLowerBounds()[1], base.getUpperBounds()[1]}}};
            this.propertyTable = new Table(data, columnNames);
        } else {
            data = new Object[][]{{"Title", this.canvas.getTitle()}, {"Title Font", this.canvas.getTitleFont()}, {"Title Color", this.canvas.getTitleColor()}, {"X Axis Title", this.canvas.getAxis(0).getLabel()}, {"X Axis Range", new double[]{base.getLowerBounds()[0], base.getUpperBounds()[0]}}, {"Y Axis Title", this.canvas.getAxis(1).getLabel()}, {"Y Axis Range", new double[]{base.getLowerBounds()[1], base.getUpperBounds()[1]}}, {"Z Axis Title", this.canvas.getAxis(2).getLabel()}, {"Z Axis Range", new double[]{base.getLowerBounds()[2], base.getUpperBounds()[2]}}};
            this.propertyTable = new Table(data, columnNames);
        }
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyTable.setFillsViewportHeight(true);
        JScrollPane tablePanel = new JScrollPane(this.propertyTable);
        dialog.getContentPane().add((Component)tablePanel, "Center");
        dialog.getContentPane().add((Component)buttonsPanel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        return dialog;
    }

    public void save() throws IOException {
        FileChooser.SimpleFileFilter filter = FileChooser.SimpleFileFilter.getWritableImageFIlter();
        FileChooser chooser = FileChooser.getInstance();
        chooser.setFileFilter(filter);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setSelectedFiles(new File[0]);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (!filter.accept(file)) {
                file = new File(file.getParentFile(), file.getName() + ".png");
            }
            this.save(file);
        }
    }

    public void save(File file) throws IOException {
        BufferedImage bi = this.canvas.toBufferedImage(this.contentPane.getWidth(), this.contentPane.getHeight());
        ImageIO.write((RenderedImage)bi, FileChooser.getExtension(file), file);
    }

    public void print() {
        Printer.getPrinter().print(this.contentPane);
    }

    public void zoom(boolean inout) {
        Base base = this.canvas.base;
        int i = 0;
        while (i < base.dimension) {
            int s = this.canvas.axis[i].slices();
            double r = inout ? -1.0 / (double)s : 1.0 / (double)s;
            double d = (base.upperBound[i] - base.lowerBound[i]) * r;
            int n = i;
            base.lowerBound[n] = base.lowerBound[n] - d;
            int n2 = i++;
            base.upperBound[n2] = base.upperBound[n2] + d;
        }
        for (i = 0; i < base.dimension; ++i) {
            base.setPrecisionUnit(i);
        }
        base.initBaseCoord();
        this.canvas.graphics.projection.reset();
        this.canvas.resetAxis();
        this.contentPane.repaint();
    }

    public void reset() {
        Base base = this.canvas.base;
        Graphics graphics = this.canvas.graphics;
        base.reset();
        graphics.projection.reset();
        this.canvas.resetAxis();
        if (graphics.projection instanceof Projection3D) {
            ((Projection3D)graphics.projection).setDefaultView();
        }
        this.contentPane.repaint();
    }

    public JFrame window() throws InterruptedException, InvocationTargetException {
        JFrame frame = new JFrame();
        String title = this.canvas.getTitle();
        if (title != null) {
            title = String.format("Smile Plot %d", WindowCount.addAndGet(1));
        }
        frame.setTitle(title);
        this.add((Component)this.toolbar, "North");
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(2);
        frame.setSize(new Dimension(1280, 800));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        SwingUtilities.invokeAndWait(() -> {
            this.reset();
            this.repaint();
            frame.toFront();
        });
        return frame;
    }

    private class JCanvas
    extends JComponent
    implements Printable,
    ComponentListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    ActionListener {
        private boolean mouseDoubleClicked = false;
        private int mouseClickX = -1;
        private int mouseClickY = -1;
        private int mouseDraggingX = -1;
        private int mouseDraggingY = -1;
        private Base backupBase;

        JCanvas() {
            this.setBackground(Color.white);
            this.setDoubleBuffered(true);
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paintComponent(java.awt.Graphics g) {
            PlotPanel.this.canvas.paint((Graphics2D)g, this.getWidth(), this.getHeight());
            if (this.mouseDraggingX >= 0 && this.mouseDraggingY >= 0) {
                g.setColor(Color.BLACK);
                g.drawRect(Math.min(this.mouseClickX, this.mouseDraggingX), Math.min(this.mouseClickY, this.mouseDraggingY), Math.abs(this.mouseClickX - this.mouseDraggingX), Math.abs(this.mouseClickY - this.mouseDraggingY));
            }
        }

        @Override
        public int print(java.awt.Graphics g, PageFormat pf, int page) throws PrinterException {
            if (page > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            double scaleX = pf.getImageableWidth() / (double)this.getWidth();
            double scaleY = pf.getImageableHeight() / (double)this.getHeight();
            g2d.scale(scaleX, scaleY);
            PlotPanel.this.canvas.paint(g2d, this.getWidth(), this.getHeight());
            return 0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PlotPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            } else {
                this.mouseClickX = e.getX();
                this.mouseClickY = e.getY();
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (((PlotPanel)PlotPanel.this).canvas.base.dimension == 2) {
                this.mouseDraggingX = e.getX();
                this.mouseDraggingY = e.getY();
            } else if (((PlotPanel)PlotPanel.this).canvas.base.dimension == 3) {
                ((PlotPanel)PlotPanel.this).canvas.graphics.rotate(e.getX() - this.mouseClickX, e.getY() - this.mouseClickY);
                this.mouseClickX = e.getX();
                this.mouseClickY = e.getY();
            }
            this.repaint();
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Base base = ((PlotPanel)PlotPanel.this).canvas.base;
            Graphics graphics = ((PlotPanel)PlotPanel.this).canvas.graphics;
            if (e.isPopupTrigger()) {
                PlotPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            } else if (this.mouseDraggingX != -1 && this.mouseDraggingY != -1) {
                double[] sc2;
                double[] sc1;
                this.mouseDraggingX = -1;
                this.mouseDraggingY = -1;
                if (base.dimension == 2 && Math.abs(e.getX() - this.mouseClickX) > 20 && Math.abs(e.getY() - this.mouseClickY) > 20 && Math.min((sc1 = ((Projection2D)graphics.projection).inverseProjection(this.mouseClickX, this.mouseClickY))[0], (sc2 = ((Projection2D)graphics.projection).inverseProjection(e.getX(), e.getY()))[0]) < base.upperBound[0] && Math.max(sc1[0], sc2[0]) > ((PlotPanel)PlotPanel.this).canvas.base.lowerBound[0] && Math.min(sc1[1], sc2[1]) < base.upperBound[1] && Math.max(sc1[1], sc2[1]) > base.lowerBound[1]) {
                    base.lowerBound[0] = Math.max(base.lowerBound[0], Math.min(sc1[0], sc2[0]));
                    base.upperBound[0] = Math.min(base.upperBound[0], Math.max(sc1[0], sc2[0]));
                    base.lowerBound[1] = Math.max(base.lowerBound[1], Math.min(sc1[1], sc2[1]));
                    base.upperBound[1] = Math.min(base.upperBound[1], Math.max(sc1[1], sc2[1]));
                    for (int i = 0; i < base.dimension; ++i) {
                        base.setPrecisionUnit(i);
                    }
                    base.initBaseCoord();
                    graphics.projection.reset();
                    PlotPanel.this.canvas.resetAxis();
                }
                this.repaint();
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.mouseDoubleClicked = true;
                this.backupBase = ((PlotPanel)PlotPanel.this).canvas.base;
            } else {
                this.mouseDoubleClicked = false;
            }
            this.mouseClickX = e.getX();
            this.mouseClickY = e.getY();
            e.consume();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Base base = ((PlotPanel)PlotPanel.this).canvas.base;
            Graphics graphics = ((PlotPanel)PlotPanel.this).canvas.graphics;
            if (base.dimension == 2) {
                if (this.mouseDoubleClicked) {
                    double y;
                    double x = this.mouseClickX - e.getX();
                    if (Math.abs(x) > 20.0) {
                        int s = ((PlotPanel)PlotPanel.this).canvas.axis[0].slices();
                        x = x > 0.0 ? 1.0 / (double)s : -1.0 / (double)s;
                        base.lowerBound[0] = this.backupBase.lowerBound[0] + (x *= this.backupBase.upperBound[0] - this.backupBase.lowerBound[0]);
                        base.upperBound[0] = this.backupBase.upperBound[0] + x;
                        this.mouseClickX = e.getX();
                    }
                    if (Math.abs(y = (double)(this.mouseClickY - e.getY())) > 20.0) {
                        int s = ((PlotPanel)PlotPanel.this).canvas.axis[1].slices();
                        y = y > 0.0 ? -1.0 / (double)s : 1.0 / (double)s;
                        base.lowerBound[1] = this.backupBase.lowerBound[1] + (y *= this.backupBase.upperBound[1] - this.backupBase.lowerBound[1]);
                        base.upperBound[1] = this.backupBase.upperBound[1] + y;
                        this.mouseClickY = e.getY();
                    }
                    base.initBaseCoord();
                    graphics.projection.reset();
                    PlotPanel.this.canvas.resetAxis();
                    this.repaint();
                } else {
                    String tooltip = null;
                    double[] sc = ((Projection2D)graphics.projection).inverseProjection(e.getX(), e.getY());
                    Object firstid = null;
                    for (Shape shape : ((PlotPanel)PlotPanel.this).canvas.shapes) {
                        String id;
                        Plot plot;
                        Optional<String> s;
                        if (!(shape instanceof Plot) || !(s = (plot = (Plot)shape).tooltip(sc)).isPresent()) continue;
                        if (tooltip == null) {
                            tooltip = s.get();
                            firstid = null;
                            continue;
                        }
                        if (firstid != null) {
                            tooltip = "<b>" + firstid + ":</b><br>" + tooltip;
                            firstid = null;
                        }
                        if ((id = null) != null) {
                            tooltip = tooltip + "<br><b>" + id + ":</b><br>" + s;
                            continue;
                        }
                        tooltip = tooltip + "<br>----------<br>" + s;
                    }
                    if (tooltip != null) {
                        this.setToolTipText(String.format("<html>%s</html>", tooltip));
                    } else {
                        this.setToolTipText(null);
                    }
                }
            }
            e.consume();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int i;
            if (e.getWheelRotation() == 0) {
                return;
            }
            Base base = ((PlotPanel)PlotPanel.this).canvas.base;
            Graphics graphics = ((PlotPanel)PlotPanel.this).canvas.graphics;
            for (i = 0; i < base.dimension; ++i) {
                double r;
                int s = ((PlotPanel)PlotPanel.this).canvas.axis[i].slices();
                double d = r = e.getWheelRotation() > 0 ? 1.0 / (double)s : -1.0 / (double)s;
                if (!(r > -0.5)) continue;
                double d2 = (base.upperBound[i] - base.lowerBound[i]) * r;
                int n = i;
                base.lowerBound[n] = base.lowerBound[n] - d2;
                int n2 = i;
                base.upperBound[n2] = base.upperBound[n2] + d2;
            }
            for (i = 0; i < base.dimension; ++i) {
                base.setPrecisionUnit(i);
            }
            base.initBaseCoord();
            graphics.projection.reset();
            PlotPanel.this.canvas.resetAxis();
            this.repaint();
            e.consume();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Base base = ((PlotPanel)PlotPanel.this).canvas.base;
            Graphics graphics = ((PlotPanel)PlotPanel.this).canvas.graphics;
            if (graphics != null) {
                base.initBaseCoord();
                graphics.projection.reset();
                PlotPanel.this.canvas.resetAxis();
            }
            this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save", new ImageIcon(PlotPanel.class.getResource("images/save16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PlotPanel.this.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super("Print", new ImageIcon(PlotPanel.class.getResource("images/print16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotPanel.this.print();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        public ZoomInAction() {
            super("Zoom In", new ImageIcon(PlotPanel.class.getResource("images/zoom-in16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotPanel.this.zoom(true);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction() {
            super("Zoom Out", new ImageIcon(PlotPanel.class.getResource("images/zoom-out16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotPanel.this.zoom(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset", new ImageIcon(PlotPanel.class.getResource("images/refresh16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotPanel.this.reset();
        }
    }

    private class EnlargePlotAreaAction
    extends AbstractAction {
        public EnlargePlotAreaAction() {
            super("Enlarge", new ImageIcon(PlotPanel.class.getResource("images/resize-larger16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((PlotPanel)PlotPanel.this).canvas.margin > 0.05) {
                ((PlotPanel)PlotPanel.this).canvas.margin -= 0.05;
                ((PlotPanel)PlotPanel.this).canvas.graphics.projection.reset();
                PlotPanel.this.repaint();
            }
            if (((PlotPanel)PlotPanel.this).canvas.margin <= 0.05) {
                this.setEnabled(false);
            }
            if (!PlotPanel.this.shrinkPlotAreaAction.isEnabled()) {
                PlotPanel.this.shrinkPlotAreaAction.setEnabled(true);
            }
        }
    }

    private class ShrinkPlotAreaAction
    extends AbstractAction {
        public ShrinkPlotAreaAction() {
            super("Shrink", new ImageIcon(PlotPanel.class.getResource("images/resize-smaller16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((PlotPanel)PlotPanel.this).canvas.margin < 0.3) {
                ((PlotPanel)PlotPanel.this).canvas.margin += 0.05;
                ((PlotPanel)PlotPanel.this).canvas.graphics.projection.reset();
                PlotPanel.this.repaint();
            }
            if (((PlotPanel)PlotPanel.this).canvas.margin >= 0.3) {
                this.setEnabled(false);
            }
            if (!PlotPanel.this.enlargePlotAreaAction.isEnabled()) {
                PlotPanel.this.enlargePlotAreaAction.setEnabled(true);
            }
        }
    }

    private class PropertyAction
    extends AbstractAction {
        public PropertyAction() {
            super("Properties", new ImageIcon(PlotPanel.class.getResource("images/property16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = PlotPanel.this.createPropertyDialog();
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    private class IncreaseHeightAction
    extends AbstractAction {
        public IncreaseHeightAction() {
            super("Increase Height", new ImageIcon(PlotPanel.class.getResource("images/increase-height16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotPanel.this.getSize();
            d.height += 100;
            PlotPanel.this.setPreferredSize(d);
            PlotPanel.this.invalidate();
            PlotPanel.this.scrollPane.getParent().validate();
            if (!PlotPanel.this.decreaseHeightAction.isEnabled()) {
                PlotPanel.this.decreaseHeightAction.setEnabled(true);
            }
        }
    }

    private class IncreaseWidthAction
    extends AbstractAction {
        public IncreaseWidthAction() {
            super("Increase Width", new ImageIcon(PlotPanel.class.getResource("images/increase-width16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotPanel.this.getSize();
            d.width += 100;
            PlotPanel.this.setPreferredSize(d);
            PlotPanel.this.invalidate();
            PlotPanel.this.scrollPane.getParent().validate();
            if (!PlotPanel.this.decreaseWidthAction.isEnabled()) {
                PlotPanel.this.decreaseWidthAction.setEnabled(true);
            }
        }
    }

    private class DecreaseHeightAction
    extends AbstractAction {
        public DecreaseHeightAction() {
            super("Decrease Height", new ImageIcon(PlotPanel.class.getResource("images/decrease-height16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotPanel.this.getSize();
            d.height -= 100;
            Dimension vd = PlotPanel.this.scrollPane.getViewport().getSize();
            if (d.height <= vd.height) {
                d.height = vd.height;
                PlotPanel.this.decreaseHeightAction.setEnabled(false);
            }
            PlotPanel.this.setPreferredSize(d);
            PlotPanel.this.invalidate();
            PlotPanel.this.scrollPane.getParent().validate();
        }
    }

    private class DecreaseWidthAction
    extends AbstractAction {
        public DecreaseWidthAction() {
            super("Decrease Width", new ImageIcon(PlotPanel.class.getResource("images/decrease-width16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotPanel.this.getSize();
            d.width -= 100;
            Dimension vd = PlotPanel.this.scrollPane.getViewport().getSize();
            if (d.width <= vd.width) {
                d.width = vd.width;
                PlotPanel.this.decreaseWidthAction.setEnabled(false);
            }
            PlotPanel.this.setPreferredSize(d);
            PlotPanel.this.invalidate();
            PlotPanel.this.scrollPane.getParent().validate();
        }
    }

    private class PropertyDialogOKAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "OK";
        private JDialog dialog;

        protected PropertyDialogOKAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotPanel.this.canvas.setTitle((String)PlotPanel.this.propertyTable.getValueAt(0, 1));
            PlotPanel.this.canvas.setTitleFont((Font)PlotPanel.this.propertyTable.getValueAt(1, 1));
            PlotPanel.this.canvas.setTitleColor((Color)PlotPanel.this.propertyTable.getValueAt(2, 1));
            PlotPanel.this.canvas.getAxis(0).setLabel((String)PlotPanel.this.propertyTable.getValueAt(3, 1));
            double[] xbound = (double[])PlotPanel.this.propertyTable.getValueAt(4, 1);
            ((PlotPanel)PlotPanel.this).canvas.base.lowerBound[0] = xbound[0];
            ((PlotPanel)PlotPanel.this).canvas.base.upperBound[0] = xbound[1];
            PlotPanel.this.canvas.getAxis(1).setLabel((String)PlotPanel.this.propertyTable.getValueAt(5, 1));
            double[] ybound = (double[])PlotPanel.this.propertyTable.getValueAt(6, 1);
            ((PlotPanel)PlotPanel.this).canvas.base.lowerBound[1] = ybound[0];
            ((PlotPanel)PlotPanel.this).canvas.base.upperBound[1] = ybound[1];
            if (((PlotPanel)PlotPanel.this).canvas.base.dimension > 2) {
                PlotPanel.this.canvas.getAxis(2).setLabel((String)PlotPanel.this.propertyTable.getValueAt(7, 1));
                double[] zbound = (double[])PlotPanel.this.propertyTable.getValueAt(8, 1);
                ((PlotPanel)PlotPanel.this).canvas.base.lowerBound[2] = zbound[0];
                ((PlotPanel)PlotPanel.this).canvas.base.upperBound[2] = zbound[1];
            }
            for (int i = 0; i < ((PlotPanel)PlotPanel.this).canvas.base.dimension; ++i) {
                ((PlotPanel)PlotPanel.this).canvas.base.setPrecisionUnit(i);
            }
            ((PlotPanel)PlotPanel.this).canvas.base.initBaseCoord();
            ((PlotPanel)PlotPanel.this).canvas.graphics.projection.reset();
            PlotPanel.this.canvas.resetAxis();
            this.dialog.setVisible(false);
            PlotPanel.this.contentPane.repaint();
        }
    }

    private class PropertyDialogCancelAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "Cancel";
        private JDialog dialog;

        protected PropertyDialogCancelAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(false);
        }
    }
}

