/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.DataFrame;
import smile.math.MathEx;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;
import smile.plot.swing.Point;

public class ScatterPlot
extends Plot {
    final Point[] points;
    final Optional<Legend[]> legends;

    public ScatterPlot(Point ... points) {
        this.points = points;
        this.legends = Optional.empty();
    }

    public ScatterPlot(Point[] points, Legend[] legends) {
        this.points = points;
        this.legends = Optional.of(legends);
    }

    @Override
    public void paint(Graphics g) {
        for (Point point : this.points) {
            point.paint(g);
        }
    }

    @Override
    public Optional<Legend[]> legends() {
        return this.legends;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = MathEx.colMin((double[][])this.points[0].points);
        for (int k = 1; k < this.points.length; ++k) {
            for (double[] x : this.points[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] > x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = MathEx.colMax((double[][])this.points[0].points);
        for (int k = 1; k < this.points.length; ++k) {
            for (double[] x : this.points[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] < x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    public static ScatterPlot of(double[][] points) {
        return new ScatterPlot(Point.of(points));
    }

    public static ScatterPlot of(double[][] points, Color color) {
        return new ScatterPlot(Point.of(points, color));
    }

    public static ScatterPlot of(double[][] points, char mark) {
        return new ScatterPlot(Point.of(points, mark));
    }

    public static ScatterPlot of(double[][] points, char mark, Color color) {
        return new ScatterPlot(new Point(points, mark, color));
    }

    public static ScatterPlot of(double[][] x, String[] y, char mark) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The number of points and that of labels are not the same.");
        }
        Map<String, List<Integer>> groups = IntStream.range(0, x.length).boxed().collect(Collectors.groupingBy(i -> y[i]));
        Point[] points = new Point[groups.size()];
        Legend[] legends = new Legend[groups.size()];
        int k = 0;
        for (Map.Entry<String, List<Integer>> group : groups.entrySet()) {
            Color color = Palette.COLORS[k % Palette.COLORS.length];
            points[k] = new Point((double[][])group.getValue().stream().map(i -> x[i]).toArray(x$0 -> new double[x$0][]), mark, color);
            legends[k] = new Legend(group.getKey(), color);
            ++k;
        }
        return new ScatterPlot(points, legends);
    }

    public static ScatterPlot of(double[][] x, int[] y, char mark) {
        return ScatterPlot.of(x, (String[])Arrays.stream(y).mapToObj(i -> String.format("class %d", i)).toArray(String[]::new), mark);
    }

    public static ScatterPlot of(DataFrame data, String x, String y, char mark, Color color) {
        int ix = data.indexOf(x);
        int iy = data.indexOf(y);
        double[][] xy = (double[][])data.stream().map(row -> new double[]{row.getDouble(ix), row.getDouble(iy)}).toArray(x$0 -> new double[x$0][]);
        return ScatterPlot.of(xy, mark, color);
    }

    public static ScatterPlot of(DataFrame data, String x, String y, String category, char mark) {
        int ix = data.indexOf(x);
        int iy = data.indexOf(y);
        double[][] xy = (double[][])data.stream().map(row -> new double[]{row.getDouble(ix), row.getDouble(iy)}).toArray(x$0 -> new double[x$0][]);
        String[] label = data.column(category).toStringArray();
        return ScatterPlot.of(xy, label, mark);
    }

    public static ScatterPlot of(DataFrame data, String x, String y, String z, char mark, Color color) {
        int ix = data.indexOf(x);
        int iy = data.indexOf(y);
        int iz = data.indexOf(z);
        double[][] xyz = (double[][])data.stream().map(row -> new double[]{row.getDouble(ix), row.getDouble(iy), row.getDouble(iz)}).toArray(x$0 -> new double[x$0][]);
        return ScatterPlot.of(xyz, mark, color);
    }

    public static ScatterPlot of(DataFrame data, String x, String y, String z, String category, char mark) {
        int ix = data.indexOf(x);
        int iy = data.indexOf(y);
        int iz = data.indexOf(z);
        double[][] xyz = (double[][])data.stream().map(row -> new double[]{row.getDouble(ix), row.getDouble(iy), row.getDouble(iz)}).toArray(x$0 -> new double[x$0][]);
        String[] label = data.column(category).toStringArray();
        return ScatterPlot.of(xyz, label, mark);
    }
}

