/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Plot;
import smile.plot.swing.Staircase;

public class StaircasePlot
extends Plot {
    final Staircase[] lines;
    final Optional<Legend[]> legends;

    public StaircasePlot(Staircase ... lines) {
        this.lines = lines;
        this.legends = Optional.empty();
    }

    public StaircasePlot(Staircase[] lines, Legend[] legends) {
        this.lines = lines;
        this.legends = Optional.of(legends);
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.base.extendBound(1);
        canvas.add(this);
        return canvas;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = MathEx.colMin((double[][])this.lines[0].points);
        for (int k = 1; k < this.lines.length; ++k) {
            for (double[] x : this.lines[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] > x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = MathEx.colMax((double[][])this.lines[0].points);
        for (int k = 1; k < this.lines.length; ++k) {
            for (double[] x : this.lines[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] < x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        for (Staircase line : this.lines) {
            line.paint(g);
        }
    }

    public static StaircasePlot of(double[][] data) {
        return new StaircasePlot(Staircase.of(data));
    }

    public static StaircasePlot of(double[][] data, Color color, String label) {
        Staircase[] line = new Staircase[]{new Staircase(data, color)};
        Legend[] legend = new Legend[]{new Legend(label, color)};
        return new StaircasePlot(line, legend);
    }
}

