/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Graphics;
import smile.plot.swing.Shape;

public class Bar
extends Shape {
    final double[][] data;
    final double width;
    final double[][] leftTop;
    final double[][] rightTop;
    final double[][] leftBottom;
    final double[][] rightBottom;

    public Bar(double[][] data, double width, Color color) {
        super(color);
        if (data[0].length != 2) {
            throw new IllegalArgumentException("Data is not 2-dimensional.");
        }
        this.data = data;
        this.width = width;
        int n = data.length;
        this.leftTop = new double[n][2];
        this.rightTop = new double[n][2];
        this.leftBottom = new double[n][2];
        this.rightBottom = new double[n][2];
        for (int i = 0; i < n; ++i) {
            this.leftTop[i][0] = data[i][0] - width / 2.0;
            this.leftTop[i][1] = data[i][1];
            this.rightTop[i][0] = data[i][0] + width / 2.0;
            this.rightTop[i][1] = data[i][1];
            this.leftBottom[i][0] = data[i][0] - width / 2.0;
            this.leftBottom[i][1] = 0.0;
            this.rightBottom[i][0] = data[i][0] + width / 2.0;
            this.rightBottom[i][1] = 0.0;
        }
    }

    @Override
    public void paint(Graphics g) {
        int i;
        g.setColor(Color.BLACK);
        for (i = 0; i < this.data.length; ++i) {
            g.drawLine(this.leftBottom[i], this.leftTop[i]);
            g.drawLine(this.leftTop[i], this.rightTop[i]);
            g.drawLine(this.rightTop[i], this.rightBottom[i]);
            g.drawLine(this.rightBottom[i], this.leftBottom[i]);
        }
        g.setColor(this.color);
        for (i = 0; i < this.data.length; ++i) {
            g.fillPolygon(0.2f, (double[][])new double[][]{this.leftBottom[i], this.leftTop[i], this.rightTop[i], this.rightBottom[i]});
        }
    }

    public static Bar of(int[] x) {
        double[][] data = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            data[i][0] = (double)i + 0.5;
            data[i][1] = x[i];
        }
        return new Bar(data, 1.0, Color.BLUE);
    }

    public static Bar of(double[] x) {
        double[][] data = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            data[i][0] = (double)i + 0.5;
            data[i][1] = x[i];
        }
        return new Bar(data, 1.0, Color.BLUE);
    }
}

