/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.util.ArrayList;
import java.util.List;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Isoline;
import smile.plot.swing.Plot;

public class Contour
extends Plot {
    private double[] x;
    private double[] y;
    private double[][] z;
    private double zMin;
    private double zMax;
    private boolean logScale = false;
    private int numLevels = 10;
    private double[] levels;
    private List<Isoline> contours;
    private boolean isTickVisible;
    private boolean isLevelVisible = true;

    public Contour(double[][] z, int numLevels, boolean logScale) {
        this.z = z;
        this.numLevels = numLevels;
        this.logScale = logScale;
        this.init();
    }

    public Contour(double[][] z, double[] levels) {
        this.z = z;
        this.levels = levels;
        this.isLevelVisible = false;
        this.init();
    }

    public Contour(double[] x, double[] y, double[][] z, int numLevels, boolean logScale) {
        if (x.length != z[0].length) {
            throw new IllegalArgumentException("x.length != z[0].length");
        }
        if (y.length != z.length) {
            throw new IllegalArgumentException("y.length != z.length");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.numLevels = numLevels;
        this.logScale = logScale;
        this.init();
    }

    public Contour(double[] x, double[] y, double[][] z, double[] levels) {
        if (x.length != z[0].length) {
            throw new IllegalArgumentException("x.length != z[0].length");
        }
        if (y.length != z.length) {
            throw new IllegalArgumentException("y.length != z.length");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.levels = levels;
        this.isLevelVisible = false;
        this.init();
    }

    private void init() {
        int i;
        boolean bl = this.isTickVisible = this.x != null || this.y != null;
        if (this.x == null) {
            this.x = new double[this.z[0].length];
            for (i = 0; i < this.x.length; ++i) {
                this.x[i] = (double)i + 0.5;
            }
        }
        if (this.y == null) {
            this.y = new double[this.z.length];
            for (i = 0; i < this.y.length; ++i) {
                this.y[i] = (double)i + 0.5;
            }
            double[][] zz = new double[this.z.length][];
            for (int i2 = 0; i2 < this.z.length; ++i2) {
                zz[i2] = this.z[this.z.length - i2 - 1];
            }
            this.z = zz;
        }
        this.zMin = MathEx.min((double[][])this.z);
        this.zMax = MathEx.max((double[][])this.z);
        this.contours = new ArrayList<Isoline>(this.numLevels);
        if (this.logScale && this.zMin <= 0.0) {
            throw new IllegalArgumentException("Log scale is not support for non-positive data");
        }
        if (this.levels == null) {
            if (this.logScale) {
                double lowerBound = Math.ceil(Math.log10(this.zMin));
                double upperBound = Math.floor(Math.log10(this.zMax));
                int n = (int)Math.round(upperBound - lowerBound);
                if (n == 0) {
                    this.logScale = false;
                }
                this.numLevels = n + 1;
                this.levels = new double[this.numLevels];
                for (int i3 = 0; i3 < this.numLevels; ++i3) {
                    this.levels[i3] = Math.pow(10.0, lowerBound + (double)i3);
                }
            }
            if (this.levels == null) {
                double digits = Math.log10(Math.abs(this.zMax - this.zMin));
                double residual = digits - Math.floor(digits);
                if (residual < 0.4) {
                    digits -= 1.0;
                }
                double precisionDigits = (int)Math.floor(digits);
                double precisionUnit = Math.pow(10.0, precisionDigits);
                if (residual >= 0.4 && residual <= 0.7) {
                    precisionUnit /= 2.0;
                    precisionDigits -= 1.0;
                }
                double lowerBound = precisionUnit * Math.ceil(this.zMin / precisionUnit);
                double upperBound = precisionUnit * Math.floor(this.zMax / precisionUnit);
                this.numLevels = (int)Math.round((upperBound - lowerBound) / precisionUnit) + 1;
                this.levels = new double[this.numLevels];
                for (int i4 = 0; i4 < this.numLevels; ++i4) {
                    this.levels[i4] = lowerBound + (double)i4 * precisionUnit;
                }
            }
        }
        double[] xx = new double[4];
        double[] yy = new double[4];
        int[] ij = new int[2];
        int nx = this.x.length;
        int ny = this.y.length;
        Segment[][] segments = new Segment[ny][nx];
        double atom = 1.0E-7 * (this.zMax - this.zMin);
        for (int c = 0; c < this.levels.length; ++c) {
            int j;
            int i5;
            double zc = this.levels[c];
            for (i5 = 0; i5 < nx; ++i5) {
                for (j = 0; j < ny; ++j) {
                    segments[j][i5] = null;
                }
            }
            for (i5 = 0; i5 < nx - 1; ++i5) {
                double xl = this.x[i5];
                double xh = this.x[i5 + 1];
                for (int j2 = 0; j2 < ny - 1; ++j2) {
                    double yl = this.y[j2];
                    double yh = this.y[j2 + 1];
                    double zll = this.z[j2][i5];
                    double zhl = this.z[j2][i5 + 1];
                    double zlh = this.z[j2 + 1][i5];
                    double zhh = this.z[j2 + 1][i5 + 1];
                    if (zll == zc) {
                        zll += atom;
                    }
                    if (zhl == zc) {
                        zhl += atom;
                    }
                    if (zlh == zc) {
                        zlh += atom;
                    }
                    if (zhh == zc) {
                        zhh += atom;
                    }
                    int nacode = 0;
                    if (!Double.isInfinite(zll)) {
                        ++nacode;
                    }
                    if (!Double.isInfinite(zhl)) {
                        nacode += 2;
                    }
                    if (!Double.isInfinite(zlh)) {
                        nacode += 4;
                    }
                    if (!Double.isInfinite(zhh)) {
                        nacode += 8;
                    }
                    int k = 0;
                    switch (nacode) {
                        case 15: {
                            double f;
                            if (this.isIntersect(zll, zhl, zc)) {
                                f = this.getIntersectRatio(zll, zhl, zc);
                                xx[k] = xl + f * (xh - xl);
                                yy[k] = yl;
                                ++k;
                            }
                            if (this.isIntersect(zll, zlh, zc)) {
                                f = this.getIntersectRatio(zll, zlh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xl;
                                ++k;
                            }
                            if (this.isIntersect(zhl, zhh, zc)) {
                                f = this.getIntersectRatio(zhl, zhh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xh;
                                ++k;
                            }
                            if (!this.isIntersect(zlh, zhh, zc)) break;
                            f = this.getIntersectRatio(zlh, zhh, zc);
                            xx[k] = xl + f * (xh - xl);
                            yy[k] = yh;
                            ++k;
                            break;
                        }
                        case 14: {
                            if (this.isIntersect(zhl, zhh, zc)) {
                                double f = this.getIntersectRatio(zhl, zhh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xh;
                                ++k;
                            }
                            if (this.isIntersect(zlh, zhh, zc)) {
                                double f = this.getIntersectRatio(zlh, zhh, zc);
                                xx[k] = xl + f * (xh - xl);
                                yy[k] = yh;
                                ++k;
                            }
                            if (!this.isIntersect(zlh, zhl, zc)) break;
                            double f = this.getIntersectRatio(zlh, zhl, zc);
                            xx[k] = xl + f * (xh - xl);
                            yy[k] = yh + f * (yl - yh);
                            ++k;
                            break;
                        }
                        case 13: {
                            if (this.isIntersect(zll, zlh, zc)) {
                                double f = this.getIntersectRatio(zll, zlh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xl;
                                ++k;
                            }
                            if (this.isIntersect(zlh, zhh, zc)) {
                                double f = this.getIntersectRatio(zlh, zhh, zc);
                                xx[k] = xl + f * (xh - xl);
                                yy[k] = yh;
                                ++k;
                            }
                            if (!this.isIntersect(zll, zhh, zc)) break;
                            double f = this.getIntersectRatio(zll, zhh, zc);
                            xx[k] = xl + f * (xh - xl);
                            yy[k] = yl + f * (yh - yl);
                            ++k;
                            break;
                        }
                        case 11: {
                            if (this.isIntersect(zhl, zhh, zc)) {
                                double f = this.getIntersectRatio(zhl, zhh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xh;
                                ++k;
                            }
                            if (this.isIntersect(zll, zhl, zc)) {
                                double f = this.getIntersectRatio(zll, zhl, zc);
                                xx[k] = xl + f * (xh - xl);
                                yy[k] = yl;
                                ++k;
                            }
                            if (!this.isIntersect(zll, zhh, zc)) break;
                            double f = this.getIntersectRatio(zll, zhh, zc);
                            xx[k] = xl + f * (xh - xl);
                            yy[k] = yl + f * (yh - yl);
                            ++k;
                            break;
                        }
                        case 7: {
                            if (this.isIntersect(zll, zlh, zc)) {
                                double f = this.getIntersectRatio(zll, zlh, zc);
                                yy[k] = yl + f * (yh - yl);
                                xx[k] = xl;
                                ++k;
                            }
                            if (this.isIntersect(zll, zhl, zc)) {
                                double f = this.getIntersectRatio(zll, zhl, zc);
                                xx[k] = xl + f * (xh - xl);
                                yy[k] = yl;
                                ++k;
                            }
                            if (!this.isIntersect(zlh, zhl, zc)) break;
                            double f = this.getIntersectRatio(zlh, zhl, zc);
                            xx[k] = xl + f * (xh - xl);
                            yy[k] = yh + f * (yl - yh);
                            ++k;
                        }
                    }
                    Segment seglist = null;
                    if (k > 0) {
                        if (k == 2) {
                            seglist = new Segment(xx[0], yy[0], xx[1], yy[1], seglist);
                        } else if (k == 4) {
                            for (k = 3; k >= 1; --k) {
                                int m = k;
                                xl = xx[k];
                                for (int l = 0; l < k; ++l) {
                                    if (!(xx[l] > xl)) continue;
                                    xl = xx[l];
                                    m = l;
                                }
                                if (m == k) continue;
                                xl = xx[k];
                                yl = yy[k];
                                xx[k] = xx[m];
                                yy[k] = yy[m];
                                xx[m] = xl;
                                yy[m] = yl;
                            }
                            seglist = new Segment(xx[0], yy[0], xx[1], yy[1], seglist);
                            seglist = new Segment(xx[2], yy[2], xx[3], yy[3], seglist);
                        } else {
                            throw new IllegalStateException("k != 2 or 4");
                        }
                    }
                    segments[j2][i5] = seglist;
                }
            }
            for (i5 = 0; i5 < nx - 1; ++i5) {
                for (j = 0; j < ny - 1; ++j) {
                    Segment seglist = null;
                    while ((seglist = segments[j][i5]) != null) {
                        Segment[] seg;
                        int jj;
                        ij[0] = i5;
                        ij[1] = j;
                        Segment start = seglist;
                        Segment end = seglist;
                        segments[j][i5] = seglist.next;
                        double xend = seglist.x1;
                        double yend = seglist.y1;
                        int dir = 0;
                        while ((dir = this.segdir(xend, yend, ij)) != 0) {
                            int ii = ij[0];
                            jj = ij[1];
                            seg = new Segment[]{segments[jj][ii], null};
                            segments[jj][ii] = this.segupdate(xend, yend, dir, true, seg);
                            if (seg[1] == null) break;
                            end.next = seg[1];
                            end = seg[1];
                            xend = end.x1;
                            yend = end.y1;
                        }
                        end.next = null;
                        ij[0] = i5;
                        ij[1] = j;
                        xend = seglist.x0;
                        yend = seglist.y0;
                        dir = 0;
                        while ((dir = this.segdir(xend, yend, ij)) != 0) {
                            int ii = ij[0];
                            jj = ij[1];
                            seg = new Segment[]{segments[jj][ii], null};
                            segments[jj][ii] = this.segupdate(xend, yend, dir, false, seg);
                            if (seg[1] == null) break;
                            seg[1].next = start;
                            start = seg[1];
                            xend = start.x0;
                            yend = start.y0;
                        }
                        Isoline contour = new Isoline(zc, this.isLevelVisible);
                        Segment s = start;
                        contour.add(s.x0, s.y0);
                        while (s.next != null) {
                            s = s.next;
                            contour.add(s.x0, s.y0);
                        }
                        contour.add(s.x1, s.y1);
                        if (contour.isEmpty()) continue;
                        this.contours.add(contour);
                    }
                }
            }
        }
    }

    private boolean isIntersect(double z0, double z1, double zc) {
        return (z0 - zc) * (z1 - zc) < 0.0;
    }

    private double getIntersectRatio(double z0, double z1, double zc) {
        return (zc - z0) / (z1 - z0);
    }

    private boolean XMATCH(double x0, double x1) {
        return Math.abs(x0 - x1) == 0.0;
    }

    private boolean YMATCH(double y0, double y1) {
        return Math.abs(y0 - y1) == 0.0;
    }

    private int segdir(double xend, double yend, int[] ij) {
        if (this.YMATCH(yend, this.y[ij[1]])) {
            if (ij[1] == 0) {
                return 0;
            }
            ij[1] = ij[1] - 1;
            return 3;
        }
        if (this.XMATCH(xend, this.x[ij[0]])) {
            if (ij[0] == 0) {
                return 0;
            }
            ij[0] = ij[0] - 1;
            return 4;
        }
        if (this.YMATCH(yend, this.y[ij[1] + 1])) {
            if (ij[1] >= this.y.length - 1) {
                return 0;
            }
            ij[1] = ij[1] + 1;
            return 1;
        }
        if (this.XMATCH(xend, this.x[ij[0] + 1])) {
            if (ij[0] >= this.x.length - 1) {
                return 0;
            }
            ij[0] = ij[0] + 1;
            return 2;
        }
        return 0;
    }

    private Segment segupdate(double xend, double yend, int dir, boolean tail, Segment[] seg) {
        Segment seglist = seg[0];
        if (seglist == null) {
            seg[1] = null;
            return null;
        }
        switch (dir) {
            case 1: 
            case 3: {
                if (this.YMATCH(yend, seglist.y0)) {
                    if (!tail) {
                        seglist.swap();
                    }
                    seg[1] = seglist;
                    return seglist.next;
                }
                if (this.YMATCH(yend, seglist.y1)) {
                    if (tail) {
                        seglist.swap();
                    }
                    seg[1] = seglist;
                    return seglist.next;
                }
                if (!this.YMATCH(yend, seglist.y1)) break;
                if (tail) {
                    seglist.swap();
                }
                seg[1] = seglist;
                return seglist.next;
            }
            case 2: 
            case 4: {
                if (this.XMATCH(xend, seglist.x0)) {
                    if (!tail) {
                        seglist.swap();
                    }
                    seg[1] = seglist;
                    return seglist.next;
                }
                if (!this.XMATCH(xend, seglist.x1)) break;
                if (tail) {
                    seglist.swap();
                }
                seg[1] = seglist;
                return seglist.next;
            }
        }
        Segment[] seg2 = new Segment[]{seglist.next, seg[1]};
        seglist.next = this.segupdate(xend, yend, dir, tail, seg2);
        seg[1] = seg2[1];
        return seglist;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{MathEx.min((double[])this.x), MathEx.min((double[])this.y)};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{MathEx.max((double[])this.x), MathEx.max((double[])this.y)};
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        for (Isoline contour : this.contours) {
            contour.paint(g);
        }
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.add(this);
        if (!this.isTickVisible) {
            canvas.getAxis(0).setTickVisible(false);
            canvas.getAxis(1).setTickVisible(false);
        }
        return canvas;
    }

    public static Contour of(double[][] z) {
        return Contour.of(z, 10);
    }

    public static Contour of(double[][] z, int numLevels) {
        return new Contour(z, numLevels, false);
    }

    public static Contour of(double[] x, double[] y, double[][] z) {
        return Contour.of(x, y, z, 10);
    }

    public static Contour of(double[] x, double[] y, double[][] z, int numLevels) {
        return new Contour(x, y, z, numLevels, false);
    }

    class Segment {
        double x0;
        double y0;
        double x1;
        double y1;
        Segment next;

        Segment(double x0, double y0, double x1, double y1, Segment next) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.next = next;
        }

        void swap() {
            double x = this.x0;
            double y = this.y0;
            this.x0 = this.x1;
            this.y0 = this.y1;
            this.x1 = x;
            this.y1 = y;
        }
    }
}

