/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Optional;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Line;
import smile.plot.swing.Plot;

public class ScreePlot
extends Plot {
    private static final Legend[] legends = new Legend[]{new Legend("Variance", Color.RED), new Legend("Cumulative Variance", Color.BLUE)};
    private final double[] x;
    private final String[] labels;
    private final Line[] lines;

    public ScreePlot(double[] varianceProportion) {
        int n = varianceProportion.length;
        this.labels = new String[n];
        this.x = new double[n];
        double[][] var = new double[n][2];
        double[][] cumVar = new double[n][2];
        for (int i = 0; i < n; ++i) {
            this.labels[i] = "PC" + (i + 1);
            this.x[i] = i + 1;
            var[i][0] = this.x[i];
            var[i][1] = varianceProportion[i];
            cumVar[i][0] = this.x[i];
            cumVar[i][1] = i == 0 ? varianceProportion[0] : cumVar[i - 1][1] + varianceProportion[i];
        }
        this.lines = new Line[]{new Line(var, Line.Style.SOLID, '@', Color.RED), new Line(cumVar, Line.Style.SOLID, '@', Color.BLUE)};
    }

    @Override
    public void paint(Graphics g) {
        for (Line line : this.lines) {
            line.paint(g);
        }
    }

    @Override
    public Optional<Legend[]> legends() {
        return Optional.of(legends);
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.setAxisLabels("Principal Component", "Proportion of Variance");
        canvas.getAxis(0).setTicks(this.labels, this.x);
        canvas.add(this);
        return canvas;
    }

    @Override
    public double[] getLowerBound() {
        return new double[]{1.0, 0.0};
    }

    @Override
    public double[] getUpperBound() {
        return new double[]{this.x.length, 1.0};
    }
}

